// Code generated by smithy-go-codegen DO NOT EDIT.

package robomaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/robomaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists world generator jobs.
func (c *Client) ListWorldGenerationJobs(ctx context.Context, params *ListWorldGenerationJobsInput, optFns ...func(*Options)) (*ListWorldGenerationJobsOutput, error) {
	if params == nil {
		params = &ListWorldGenerationJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWorldGenerationJobs", params, optFns, c.addOperationListWorldGenerationJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWorldGenerationJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWorldGenerationJobsInput struct {

	// Optional filters to limit results. You can use status and templateId .
	Filters []types.Filter

	// When this parameter is used, ListWorldGeneratorJobs only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another
	// ListWorldGeneratorJobs request with the returned nextToken value. This value
	// can be between 1 and 100. If this parameter is not used, then
	// ListWorldGeneratorJobs returns up to 100 results and a nextToken value if
	// applicable.
	MaxResults *int32

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldGenerationJobsRequest again and assign
	// that token to the request object's nextToken parameter. If there are no
	// remaining results, the previous response object's NextToken parameter is set to
	// null.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWorldGenerationJobsOutput struct {

	// Summary information for world generator jobs.
	//
	// This member is required.
	WorldGenerationJobSummaries []types.WorldGenerationJobSummary

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldGeneratorJobsRequest again and assign
	// that token to the request object's nextToken parameter. If there are no
	// remaining results, the previous response object's NextToken parameter is set to
	// null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWorldGenerationJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListWorldGenerationJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListWorldGenerationJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWorldGenerationJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWorldGenerationJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListWorldGenerationJobsAPIClient is a client that implements the
// ListWorldGenerationJobs operation.
type ListWorldGenerationJobsAPIClient interface {
	ListWorldGenerationJobs(context.Context, *ListWorldGenerationJobsInput, ...func(*Options)) (*ListWorldGenerationJobsOutput, error)
}

var _ ListWorldGenerationJobsAPIClient = (*Client)(nil)

// ListWorldGenerationJobsPaginatorOptions is the paginator options for
// ListWorldGenerationJobs
type ListWorldGenerationJobsPaginatorOptions struct {
	// When this parameter is used, ListWorldGeneratorJobs only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another
	// ListWorldGeneratorJobs request with the returned nextToken value. This value
	// can be between 1 and 100. If this parameter is not used, then
	// ListWorldGeneratorJobs returns up to 100 results and a nextToken value if
	// applicable.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWorldGenerationJobsPaginator is a paginator for ListWorldGenerationJobs
type ListWorldGenerationJobsPaginator struct {
	options   ListWorldGenerationJobsPaginatorOptions
	client    ListWorldGenerationJobsAPIClient
	params    *ListWorldGenerationJobsInput
	nextToken *string
	firstPage bool
}

// NewListWorldGenerationJobsPaginator returns a new
// ListWorldGenerationJobsPaginator
func NewListWorldGenerationJobsPaginator(client ListWorldGenerationJobsAPIClient, params *ListWorldGenerationJobsInput, optFns ...func(*ListWorldGenerationJobsPaginatorOptions)) *ListWorldGenerationJobsPaginator {
	if params == nil {
		params = &ListWorldGenerationJobsInput{}
	}

	options := ListWorldGenerationJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWorldGenerationJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWorldGenerationJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWorldGenerationJobs page.
func (p *ListWorldGenerationJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWorldGenerationJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListWorldGenerationJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListWorldGenerationJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWorldGenerationJobs",
	}
}
