/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"encoding/json"
	"testing"
)

func TestWriteRequestDeletes(t *testing.T) {
	t.Run("NewWriteRequestDeletes sets default OnMissing", func(t *testing.T) {
		tupleKeys := []TupleKeyWithoutCondition{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		deletes := NewWriteRequestDeletes(tupleKeys)

		if deletes.OnMissing == nil {
			t.Fatalf("Expected OnMissing to be non-nil with default value")
		}

		if *deletes.OnMissing != "error" {
			t.Fatalf("Expected OnMissing default to be 'error', got %v", *deletes.OnMissing)
		}

		if len(deletes.TupleKeys) != 1 {
			t.Fatalf("Expected 1 tuple key, got %d", len(deletes.TupleKeys))
		}
	})

	t.Run("NewWriteRequestDeletesWithDefaults sets default OnMissing", func(t *testing.T) {
		deletes := NewWriteRequestDeletesWithDefaults()

		if deletes.OnMissing == nil {
			t.Fatalf("Expected OnMissing to be non-nil with default value")
		}

		if *deletes.OnMissing != "error" {
			t.Fatalf("Expected OnMissing default to be 'error', got %v", *deletes.OnMissing)
		}
	})

	t.Run("GetOnMissing returns correct value", func(t *testing.T) {
		deletes := WriteRequestDeletes{}

		// Test when OnMissing is nil
		if deletes.GetOnMissing() != "" {
			t.Fatalf("Expected empty string when OnMissing is nil, got %v", deletes.GetOnMissing())
		}

		// Test when OnMissing is set
		onMiss := "ignore"
		deletes.OnMissing = &onMiss

		if deletes.GetOnMissing() != "ignore" {
			t.Fatalf("Expected 'ignore', got %v", deletes.GetOnMissing())
		}
	})

	t.Run("GetOnMissingOk returns correct value and status", func(t *testing.T) {
		deletes := WriteRequestDeletes{}

		// Test when OnMissing is nil
		value, ok := deletes.GetOnMissingOk()
		if value != nil || ok {
			t.Fatalf("Expected nil value and false status when OnMissing is nil, got %v, %v", value, ok)
		}

		// Test when OnMissing is set
		onMiss := "ignore"
		deletes.OnMissing = &onMiss

		value, ok = deletes.GetOnMissingOk()
		if value == nil || !ok || *value != "ignore" {
			t.Fatalf("Expected 'ignore' value and true status, got %v, %v", value, ok)
		}
	})

	t.Run("HasOnMissing returns correct status", func(t *testing.T) {
		deletes := WriteRequestDeletes{}

		// Test when OnMissing is nil
		if deletes.HasOnMissing() {
			t.Fatalf("Expected false when OnMissing is nil")
		}

		// Test when OnMissing is set
		onMiss := "ignore"
		deletes.OnMissing = &onMiss

		if !deletes.HasOnMissing() {
			t.Fatalf("Expected true when OnMissing is set")
		}
	})

	t.Run("SetOnMissing sets value correctly", func(t *testing.T) {
		deletes := WriteRequestDeletes{}

		deletes.SetOnMissing("ignore")

		if deletes.OnMissing == nil || *deletes.OnMissing != "ignore" {
			t.Fatalf("Expected OnMissing to be 'ignore', got %v", deletes.OnMissing)
		}
	})

	t.Run("MarshalJSON includes OnMissing when set", func(t *testing.T) {
		tupleKeys := []TupleKeyWithoutCondition{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		deletes := WriteRequestDeletes{
			TupleKeys: tupleKeys,
		}

		// Test without OnMissing
		jsonData, err := deletes.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling JSON: %v", err)
		}

		var result map[string]interface{}
		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if _, exists := result["on_missing"]; exists {
			t.Fatalf("Expected on_missing to not be present when nil")
		}

		// Test with OnMissing
		onMiss := "ignore"
		deletes.OnMissing = &onMiss

		jsonData, err = deletes.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling JSON: %v", err)
		}

		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if result["on_missing"] != "ignore" {
			t.Fatalf("Expected on_missing to be 'ignore', got %v", result["on_missing"])
		}
	})

	t.Run("OnMissing validation - valid values", func(t *testing.T) {
		validValues := []string{"error", "ignore"}

		for _, value := range validValues {
			deletes := WriteRequestDeletes{}
			deletes.SetOnMissing(value)

			if deletes.GetOnMissing() != value {
				t.Fatalf("Expected OnMissing to be '%s', got %v", value, deletes.GetOnMissing())
			}
		}
	})
}

func TestWriteRequestWrites(t *testing.T) {
	t.Run("NewWriteRequestWrites sets default OnDuplicate", func(t *testing.T) {
		tupleKeys := []TupleKey{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		writes := NewWriteRequestWrites(tupleKeys)

		if writes.OnDuplicate == nil {
			t.Fatalf("Expected OnDuplicate to be non-nil with default value")
		}

		if *writes.OnDuplicate != "error" {
			t.Fatalf("Expected OnDuplicate default to be 'error', got %v", *writes.OnDuplicate)
		}

		if len(writes.TupleKeys) != 1 {
			t.Fatalf("Expected 1 tuple key, got %d", len(writes.TupleKeys))
		}
	})

	t.Run("NewWriteRequestWritesWithDefaults sets default OnDuplicate", func(t *testing.T) {
		writes := NewWriteRequestWritesWithDefaults()

		if writes.OnDuplicate == nil {
			t.Fatalf("Expected OnDuplicate to be non-nil with default value")
		}

		if *writes.OnDuplicate != "error" {
			t.Fatalf("Expected OnDuplicate default to be 'error', got %v", *writes.OnDuplicate)
		}
	})

	t.Run("GetOnDuplicate returns correct value", func(t *testing.T) {
		writes := WriteRequestWrites{}

		// Test when OnDuplicate is nil
		if writes.GetOnDuplicate() != "" {
			t.Fatalf("Expected empty string when OnDuplicate is nil, got %v", writes.GetOnDuplicate())
		}

		// Test when OnDuplicate is set
		onDup := "ignore"
		writes.OnDuplicate = &onDup

		if writes.GetOnDuplicate() != "ignore" {
			t.Fatalf("Expected 'ignore', got %v", writes.GetOnDuplicate())
		}
	})

	t.Run("GetOnDuplicateOk returns correct value and status", func(t *testing.T) {
		writes := WriteRequestWrites{}

		// Test when OnDuplicate is nil
		value, ok := writes.GetOnDuplicateOk()
		if value != nil || ok {
			t.Fatalf("Expected nil value and false status when OnDuplicate is nil, got %v, %v", value, ok)
		}

		// Test when OnDuplicate is set
		onDup := "ignore"
		writes.OnDuplicate = &onDup

		value, ok = writes.GetOnDuplicateOk()
		if value == nil || !ok || *value != "ignore" {
			t.Fatalf("Expected 'ignore' value and true status, got %v, %v", value, ok)
		}
	})

	t.Run("HasOnDuplicate returns correct status", func(t *testing.T) {
		writes := WriteRequestWrites{}

		// Test when OnDuplicate is nil
		if writes.HasOnDuplicate() {
			t.Fatalf("Expected false when OnDuplicate is nil")
		}

		// Test when OnDuplicate is set
		onDup := "ignore"
		writes.OnDuplicate = &onDup

		if !writes.HasOnDuplicate() {
			t.Fatalf("Expected true when OnDuplicate is set")
		}
	})

	t.Run("SetOnDuplicate sets value correctly", func(t *testing.T) {
		writes := WriteRequestWrites{}

		writes.SetOnDuplicate("ignore")

		if writes.OnDuplicate == nil || *writes.OnDuplicate != "ignore" {
			t.Fatalf("Expected OnDuplicate to be 'ignore', got %v", writes.OnDuplicate)
		}
	})

	t.Run("MarshalJSON includes OnDuplicate when set", func(t *testing.T) {
		tupleKeys := []TupleKey{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		writes := WriteRequestWrites{
			TupleKeys: tupleKeys,
		}

		// Test without OnDuplicate
		jsonData, err := writes.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling JSON: %v", err)
		}

		var result map[string]interface{}
		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if _, exists := result["on_duplicate"]; exists {
			t.Fatalf("Expected on_duplicate to not be present when nil")
		}

		// Test with OnDuplicate
		onDup := "ignore"
		writes.OnDuplicate = &onDup

		jsonData, err = writes.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling JSON: %v", err)
		}

		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if result["on_duplicate"] != "ignore" {
			t.Fatalf("Expected on_duplicate to be 'ignore', got %v", result["on_duplicate"])
		}
	})

	t.Run("OnDuplicate validation - valid values", func(t *testing.T) {
		validValues := []string{"error", "ignore"}

		for _, value := range validValues {
			writes := WriteRequestWrites{}
			writes.SetOnDuplicate(value)

			if writes.GetOnDuplicate() != value {
				t.Fatalf("Expected OnDuplicate to be '%s', got %v", value, writes.GetOnDuplicate())
			}
		}
	})
}

func TestWriteRequest(t *testing.T) {
	t.Run("NewWriteRequest creates empty WriteRequest", func(t *testing.T) {
		writeRequest := NewWriteRequest()

		if writeRequest == nil {
			t.Fatalf("Expected non-nil WriteRequest")
		}

		if writeRequest.Writes != nil {
			t.Fatalf("Expected Writes to be nil by default")
		}

		if writeRequest.Deletes != nil {
			t.Fatalf("Expected Deletes to be nil by default")
		}

		if writeRequest.AuthorizationModelId != nil {
			t.Fatalf("Expected AuthorizationModelId to be nil by default")
		}
	})

	t.Run("NewWriteRequestWithDefaults creates empty WriteRequest", func(t *testing.T) {
		writeRequest := NewWriteRequestWithDefaults()

		if writeRequest == nil {
			t.Fatalf("Expected non-nil WriteRequest")
		}

		if writeRequest.Writes != nil {
			t.Fatalf("Expected Writes to be nil by default")
		}

		if writeRequest.Deletes != nil {
			t.Fatalf("Expected Deletes to be nil by default")
		}

		if writeRequest.AuthorizationModelId != nil {
			t.Fatalf("Expected AuthorizationModelId to be nil by default")
		}
	})

	t.Run("Writes field operations", func(t *testing.T) {
		writeRequest := WriteRequest{}

		// Test GetWrites when nil
		writes := writeRequest.GetWrites()
		if writes.TupleKeys != nil {
			t.Fatalf("Expected empty WriteRequestWrites when Writes is nil")
		}

		// Test GetWritesOk when nil
		writesPtr, ok := writeRequest.GetWritesOk()
		if writesPtr != nil || ok {
			t.Fatalf("Expected nil pointer and false when Writes is nil, got %v, %v", writesPtr, ok)
		}

		// Test HasWrites when nil
		if writeRequest.HasWrites() {
			t.Fatalf("Expected false when Writes is nil")
		}

		// Test SetWrites
		tupleKeys := []TupleKey{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}
		writesValue := WriteRequestWrites{TupleKeys: tupleKeys}
		writeRequest.SetWrites(writesValue)

		// Test GetWrites after setting
		retrievedWrites := writeRequest.GetWrites()
		if len(retrievedWrites.TupleKeys) != 1 {
			t.Fatalf("Expected 1 tuple key, got %d", len(retrievedWrites.TupleKeys))
		}

		// Test GetWritesOk after setting
		writesPtr, ok = writeRequest.GetWritesOk()
		if writesPtr == nil || !ok || len(writesPtr.TupleKeys) != 1 {
			t.Fatalf("Expected valid pointer and true after setting Writes")
		}

		// Test HasWrites after setting
		if !writeRequest.HasWrites() {
			t.Fatalf("Expected true after setting Writes")
		}
	})

	t.Run("Deletes field operations", func(t *testing.T) {
		writeRequest := WriteRequest{}

		// Test GetDeletes when nil
		deletes := writeRequest.GetDeletes()
		if deletes.TupleKeys != nil {
			t.Fatalf("Expected empty WriteRequestDeletes when Deletes is nil")
		}

		// Test GetDeletesOk when nil
		deletesPtr, ok := writeRequest.GetDeletesOk()
		if deletesPtr != nil || ok {
			t.Fatalf("Expected nil pointer and false when Deletes is nil, got %v, %v", deletesPtr, ok)
		}

		// Test HasDeletes when nil
		if writeRequest.HasDeletes() {
			t.Fatalf("Expected false when Deletes is nil")
		}

		// Test SetDeletes
		tupleKeys := []TupleKeyWithoutCondition{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}
		deletesValue := WriteRequestDeletes{TupleKeys: tupleKeys}
		writeRequest.SetDeletes(deletesValue)

		// Test GetDeletes after setting
		retrievedDeletes := writeRequest.GetDeletes()
		if len(retrievedDeletes.TupleKeys) != 1 {
			t.Fatalf("Expected 1 tuple key, got %d", len(retrievedDeletes.TupleKeys))
		}

		// Test GetDeletesOk after setting
		deletesPtr, ok = writeRequest.GetDeletesOk()
		if deletesPtr == nil || !ok || len(deletesPtr.TupleKeys) != 1 {
			t.Fatalf("Expected valid pointer and true after setting Deletes")
		}

		// Test HasDeletes after setting
		if !writeRequest.HasDeletes() {
			t.Fatalf("Expected true after setting Deletes")
		}
	})

	t.Run("AuthorizationModelId field operations", func(t *testing.T) {
		writeRequest := WriteRequest{}

		// Test GetAuthorizationModelId when nil
		modelId := writeRequest.GetAuthorizationModelId()
		if modelId != "" {
			t.Fatalf("Expected empty string when AuthorizationModelId is nil, got %v", modelId)
		}

		// Test GetAuthorizationModelIdOk when nil
		modelIdPtr, ok := writeRequest.GetAuthorizationModelIdOk()
		if modelIdPtr != nil || ok {
			t.Fatalf("Expected nil pointer and false when AuthorizationModelId is nil, got %v, %v", modelIdPtr, ok)
		}

		// Test HasAuthorizationModelId when nil
		if writeRequest.HasAuthorizationModelId() {
			t.Fatalf("Expected false when AuthorizationModelId is nil")
		}

		// Test SetAuthorizationModelId
		expectedModelId := "01GAHCE4YVKPQEKZQHT2R89MQV"
		writeRequest.SetAuthorizationModelId(expectedModelId)

		// Test GetAuthorizationModelId after setting
		retrievedModelId := writeRequest.GetAuthorizationModelId()
		if retrievedModelId != expectedModelId {
			t.Fatalf("Expected %s, got %s", expectedModelId, retrievedModelId)
		}

		// Test GetAuthorizationModelIdOk after setting
		modelIdPtr, ok = writeRequest.GetAuthorizationModelIdOk()
		if modelIdPtr == nil || !ok || *modelIdPtr != expectedModelId {
			t.Fatalf("Expected valid pointer and true after setting AuthorizationModelId")
		}

		// Test HasAuthorizationModelId after setting
		if !writeRequest.HasAuthorizationModelId() {
			t.Fatalf("Expected true after setting AuthorizationModelId")
		}
	})

	t.Run("MarshalJSON includes all fields when set", func(t *testing.T) {
		writeRequest := WriteRequest{}

		// Test marshaling empty request
		jsonData, err := writeRequest.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling empty WriteRequest: %v", err)
		}

		var result map[string]interface{}
		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if len(result) != 0 {
			t.Fatalf("Expected empty object for empty WriteRequest, got %v", result)
		}

		// Test marshaling with all fields set
		tupleKeysWrite := []TupleKey{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}
		tupleKeysDelete := []TupleKeyWithoutCondition{
			{
				User:     "user:another-user",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		onDuplicate := "ignore"
		onMissing := "ignore"
		writes := WriteRequestWrites{TupleKeys: tupleKeysWrite, OnDuplicate: &onDuplicate}
		deletes := WriteRequestDeletes{TupleKeys: tupleKeysDelete, OnMissing: &onMissing}
		modelId := "01GAHCE4YVKPQEKZQHT2R89MQV"

		writeRequest.SetWrites(writes)
		writeRequest.SetDeletes(deletes)
		writeRequest.SetAuthorizationModelId(modelId)

		jsonData, err = writeRequest.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling complete WriteRequest: %v", err)
		}

		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		// Verify all fields are present
		if _, exists := result["writes"]; !exists {
			t.Fatalf("Expected 'writes' field in JSON")
		}

		if _, exists := result["deletes"]; !exists {
			t.Fatalf("Expected 'deletes' field in JSON")
		}

		if _, exists := result["authorization_model_id"]; !exists {
			t.Fatalf("Expected 'authorization_model_id' field in JSON")
		}

		if result["authorization_model_id"] != modelId {
			t.Fatalf("Expected authorization_model_id to be %s, got %v", modelId, result["authorization_model_id"])
		}

		// Verify nested conflict options are preserved
		writesMap := result["writes"].(map[string]interface{})
		if writesMap["on_duplicate"] != "ignore" {
			t.Fatalf("Expected writes.on_duplicate to be 'ignore', got %v", writesMap["on_duplicate"])
		}

		deletesMap := result["deletes"].(map[string]interface{})
		if deletesMap["on_missing"] != "ignore" {
			t.Fatalf("Expected deletes.on_missing to be 'ignore', got %v", deletesMap["on_missing"])
		}
	})

	t.Run("WriteRequest with only writes", func(t *testing.T) {
		writeRequest := WriteRequest{}

		tupleKeys := []TupleKey{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		onDuplicate := "error"
		writes := WriteRequestWrites{TupleKeys: tupleKeys, OnDuplicate: &onDuplicate}
		writeRequest.SetWrites(writes)

		// Verify only writes is set
		if !writeRequest.HasWrites() {
			t.Fatalf("Expected HasWrites to be true")
		}

		if writeRequest.HasDeletes() {
			t.Fatalf("Expected HasDeletes to be false")
		}

		if writeRequest.HasAuthorizationModelId() {
			t.Fatalf("Expected HasAuthorizationModelId to be false")
		}

		// Test JSON marshaling
		jsonData, err := writeRequest.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling WriteRequest: %v", err)
		}

		var result map[string]interface{}
		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if _, exists := result["writes"]; !exists {
			t.Fatalf("Expected 'writes' field in JSON")
		}

		if _, exists := result["deletes"]; exists {
			t.Fatalf("Expected 'deletes' field to not be in JSON")
		}

		if _, exists := result["authorization_model_id"]; exists {
			t.Fatalf("Expected 'authorization_model_id' field to not be in JSON")
		}
	})

	t.Run("WriteRequest with only deletes", func(t *testing.T) {
		writeRequest := WriteRequest{}

		tupleKeys := []TupleKeyWithoutCondition{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		onMissing := "error"
		deletes := WriteRequestDeletes{TupleKeys: tupleKeys, OnMissing: &onMissing}
		writeRequest.SetDeletes(deletes)

		// Verify only deletes is set
		if writeRequest.HasWrites() {
			t.Fatalf("Expected HasWrites to be false")
		}

		if !writeRequest.HasDeletes() {
			t.Fatalf("Expected HasDeletes to be true")
		}

		if writeRequest.HasAuthorizationModelId() {
			t.Fatalf("Expected HasAuthorizationModelId to be false")
		}

		// Test JSON marshaling
		jsonData, err := writeRequest.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling WriteRequest: %v", err)
		}

		var result map[string]interface{}
		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		if _, exists := result["writes"]; exists {
			t.Fatalf("Expected 'writes' field to not be in JSON")
		}

		if _, exists := result["deletes"]; !exists {
			t.Fatalf("Expected 'deletes' field in JSON")
		}

		if _, exists := result["authorization_model_id"]; exists {
			t.Fatalf("Expected 'authorization_model_id' field to not be in JSON")
		}
	})

	t.Run("WriteRequest with conflict options integration", func(t *testing.T) {
		writeRequest := WriteRequest{}

		// Test with writes having ignore duplicate policy
		tupleKeysWrite := []TupleKey{
			{
				User:     "user:81684243-9356-4421-8fbf-a4f8d36aa31b",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		// Test with deletes having ignore missing policy
		tupleKeysDelete := []TupleKeyWithoutCondition{
			{
				User:     "user:another-user",
				Relation: "viewer",
				Object:   "document:0192ab2a-d83f-756d-9397-c5ed9f3cb69a",
			},
		}

		onDuplicate := "ignore"
		onMissing := "ignore"

		writes := WriteRequestWrites{TupleKeys: tupleKeysWrite, OnDuplicate: &onDuplicate}
		deletes := WriteRequestDeletes{TupleKeys: tupleKeysDelete, OnMissing: &onMissing}

		writeRequest.SetWrites(writes)
		writeRequest.SetDeletes(deletes)
		writeRequest.SetAuthorizationModelId("01GAHCE4YVKPQEKZQHT2R89MQV")

		// Verify conflict options are preserved through getter methods
		retrievedWrites := writeRequest.GetWrites()
		if retrievedWrites.GetOnDuplicate() != "ignore" {
			t.Fatalf("Expected OnDuplicate to be 'ignore', got %v", retrievedWrites.GetOnDuplicate())
		}

		retrievedDeletes := writeRequest.GetDeletes()
		if retrievedDeletes.GetOnMissing() != "ignore" {
			t.Fatalf("Expected OnMissing to be 'ignore', got %v", retrievedDeletes.GetOnMissing())
		}

		// Verify JSON serialization preserves conflict options
		jsonData, err := writeRequest.MarshalJSON()
		if err != nil {
			t.Fatalf("Error marshaling WriteRequest: %v", err)
		}

		var result map[string]interface{}
		if err := json.Unmarshal(jsonData, &result); err != nil {
			t.Fatalf("Error unmarshaling JSON: %v", err)
		}

		writesMap := result["writes"].(map[string]interface{})
		if writesMap["on_duplicate"] != "ignore" {
			t.Fatalf("Expected writes.on_duplicate to be 'ignore' in JSON, got %v", writesMap["on_duplicate"])
		}

		deletesMap := result["deletes"].(map[string]interface{})
		if deletesMap["on_missing"] != "ignore" {
			t.Fatalf("Expected deletes.on_missing to be 'ignore' in JSON, got %v", deletesMap["on_missing"])
		}
	})
}
