/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.memory;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Chain {
    private final Object value;
    private final Chain parent;

    Chain(Chain parent, Object value) {
        this.parent = parent;
        this.value = value;
    }

    static Chain root(Object value) {
        return new Chain(null, Preconditions.checkNotNull((Object)value)){

            @Override
            public Class<?> getValueType() {
                return this.getValue().getClass();
            }
        };
    }

    FieldChain appendField(Field field, Object value) {
        return new FieldChain(this, (Field)Preconditions.checkNotNull((Object)field), value);
    }

    ArrayIndexChain appendArrayIndex(int arrayIndex, Object value) {
        return new ArrayIndexChain(this, arrayIndex, value);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Nonnull
    public Chain getParent() {
        Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"This is the root value, it has no parent");
        return this.parent;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nonnull
    public abstract Class<?> getValueType();

    public boolean isThroughField() {
        return false;
    }

    public boolean isThroughArrayIndex() {
        return false;
    }

    public boolean isPrimitive() {
        return this.getValueType().isPrimitive();
    }

    @Nonnull
    public Object getRoot() {
        Chain current = this;
        while (current.hasParent()) {
            current = current.getParent();
        }
        return current.getValue();
    }

    Deque<Chain> reverse() {
        ArrayDeque<Chain> reverseChain = new ArrayDeque<Chain>(8);
        Chain current = this;
        reverseChain.addFirst(current);
        while (current.hasParent()) {
            current = current.getParent();
            reverseChain.addFirst(current);
        }
        return reverseChain;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(32);
        Iterator<Chain> it = this.reverse().iterator();
        sb.append(it.next().getValue());
        while (it.hasNext()) {
            sb.append("->");
            Chain current = it.next();
            if (current.isThroughField()) {
                sb.append(((FieldChain)current).getField().getName());
                continue;
            }
            if (!current.isThroughArrayIndex()) continue;
            sb.append("[").append(((ArrayIndexChain)current).getArrayIndex()).append("]");
        }
        return sb.toString();
    }

    static class ArrayIndexChain
    extends Chain {
        private final int index;

        ArrayIndexChain(Chain parent, int index, Object value) {
            super(parent, value);
            this.index = index;
        }

        @Override
        public boolean isThroughField() {
            return false;
        }

        @Override
        public boolean isThroughArrayIndex() {
            return true;
        }

        @Override
        public Class<?> getValueType() {
            return this.getParent().getValue().getClass().getComponentType();
        }

        public int getArrayIndex() {
            return this.index;
        }
    }

    static class FieldChain
    extends Chain {
        private final Field field;

        FieldChain(Chain parent, Field referringField, Object value) {
            super(parent, value);
            this.field = referringField;
        }

        @Override
        public boolean isThroughField() {
            return true;
        }

        @Override
        public boolean isThroughArrayIndex() {
            return false;
        }

        @Override
        public Class<?> getValueType() {
            return this.field.getType();
        }

        public Field getField() {
            return this.field;
        }
    }
}

