# Thread Safety Chart

**Analysis of Thread Safety Needs of MPI Routines**

| Comm I/O | Collective | Access Only | Update RefCount | Read of List | Update List | Allocate | Own | None | Other | MPI Routine                       | Arguments                                                                                                                     |
| -------- | ---------- | ----------- | --------------- | ------------ | ----------- | -------- | --- | ---- | ----- | --------------------------------- | ----------------------------------------------------------------------------------------------------------------------------- |
|          |            |             |                 |              |             |          |     |      | X     | MPI_ABORT                        | comm, errorcode                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_ADDRESS                      | location, address                                                                                                             |
|          | X          |             |                 |              |             |          |     |      |       | MPI_ALLGATHER                    | sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_ALLGATHERV                   | sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, comm                                                     |
|          | X          |             |                 |              |             |          |     |      |       | MPI_ALLREDUCE                    | sendbuf, recvbuf, count, datatype, op, comm                                                                                   |
|          | X          |             |                 |              |             |          |     |      |       | MPI_ALLTOALL                     | sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_ALLTOALLV                    | sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, rdispls, recvtype, comm                                          |
|          |            |             |                 |              | X           |          |     |      |       | MPI_ATTR_DELETE                 | comm, keyval                                                                                                                  |
|          |            |             |                 | X            |             |          |     |      |       | MPI_ATTR_GET                    | comm, keyval, attribute_val, flag                                                                                            |
|          |            |             |                 |              | X           |          |     |      |       | MPI_ATTR_PUT                    | comm, keyval, attribute_val                                                                                                  |
|          | X          |             |                 |              |             |          |     |      |       | MPI_BARRIER                      | comm                                                                                                                          |
|          | X          |             |                 |              |             |          |     |      |       | MPI_BCAST                        | buffer, count, datatype, root, comm                                                                                           |
| X        |            |             |                 |              |             |          |     |      |       | MPI_BSEND                        | buf, count, datatype, dest, tag, comm                                                                                         |
|          |            |             |                 |              |             | X        |     |      |       | MPI_BSEND_INIT                  | buf, count, datatype, dest, tag, comm, request                                                                                |
|          |            |             |                 |              |             |          | X   |      |       | MPI_BUFFER_ATTACH               | buffer, size                                                                                                                  |
|          |            |             |                 |              |             |          | X   |      |       | MPI_BUFFER_DETACH               | buffer_addr, size                                                                                                            |
| X        |            |             |                 |              |             |          |     |      |       | MPI_CANCEL                       | request                                                                                                                       |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CARTDIM_GET                 | comm, ndims                                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CART_COORDS                 | comm, rank, maxdims, coords                                                                                                   |
|          |            |             |                 |              |             |          | X   |      |       | MPI_CART_CREATE                 | comm_old, ndims, dims, periods, reorder, comm_cart                                                                          |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CART_GET                    | comm, maxdims, dims, periods, coords                                                                                          |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CART_MAP                    | comm, ndims, dims, periods, newrank                                                                                           |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CART_RANK                   | comm, coords, rank                                                                                                            |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CART_SHIFT                  | comm, direction, disp, rank_source, rank_dest                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_CART_SUB                    | comm, remain_dims, newcomm                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_COMPARE                | comm1, comm2, result                                                                                                          |
|          |            |             |                 |              |             |          | X   |      |       | MPI_COMM_CREATE                 | comm, group, newcomm                                                                                                          |
|          |            |             |                 |              |             |          | X   |      |       | MPI_COMM_DUP                    | comm, newcomm                                                                                                                 |
|          |            |             |                 |              |             |          | X   |      |       | MPI_COMM_FREE                   | comm                                                                                                                          |
|          |            |             | X               |              |             |          |     |      |       | MPI_COMM_GROUP                  | comm, group                                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_RANK                   | comm, rank                                                                                                                    |
|          |            |             | X               |              |             |          |     |      |       | MPI_COMM_REMOTE_GROUP          | comm, group                                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_REMOTE_SIZE           | comm, size                                                                                                                    |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_SIZE                   | comm, size                                                                                                                    |
|          |            |             |                 |              |             |          | X   |      |       | MPI_COMM_SPLIT                  | comm, color, key, newcomm                                                                                                     |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_TEST_INTER            | comm, flag                                                                                                                    |
|          |            |             |                 |              |             |          |     | X    |       | MPI_DIMS_CREATE                 | nnodes, ndims, dims                                                                                                           |
|          |            |             |                 |              |             | X        |     |      |       | MPI_ERRHANDLER_CREATE           | function, errhandler                                                                                                          |
|          |            |             |                 |              |             | X        |     |      |       | MPI_ERRHANDLER_FREE             | errhandler                                                                                                                    |
|          |            |             | X               |              |             |          |     |      |       | MPI_ERRHANDLER_GET              | comm, errhandler                                                                                                              |
|          |            |             | X               |              |             |          |     |      |       | MPI_ERRHANDLER_SET              | comm, errhandler                                                                                                              |
|          |            | X           |                 |              |             |          |     |      |       | MPI_ERROR_CLASS                 | errorcode, errorclass                                                                                                         |
|          |            | X           |                 |              |             |          |     |      |       | MPI_ERROR_STRING                | errorcode, string, resultlen                                                                                                  |
|          |            |             |                 |              |             |          |     |      | X     | MPI_FINALIZE                     |                                                                                                                               |
|          | X          |             |                 |              |             |          |     |      |       | MPI_GATHER                       | sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm                                                        |
|          | X          |             |                 |              |             |          |     |      |       | MPI_GATHERV                      | sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, root, comm                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GET_COUNT                   | status, datatype, count                                                                                                       |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GET_ELEMENTS                | status, datatype, count                                                                                                       |
|          |            |             |                 |              |             |          |     | X    |       | MPI_GET_PROCESSOR_NAME         | name, resultlen                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GRAPHDIMS_GET               | comm, nnodes, nedges                                                                                                          |
|          |            |             |                 |              |             |          | X   |      |       | MPI_GRAPH_CREATE                | comm_old, nnodes, index, edges, reorder, comm_graph                                                                         |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GRAPH_GET                   | comm, maxindex, maxedges, index, edges                                                                                        |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GRAPH_MAP                   | comm, nnodes, index, edges, newrank                                                                                           |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GRAPH_NEIGHBORS             | comm, rank, maxneighbors, neighbors                                                                                           |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GRAPH_NEIGHBORS_COUNT      | comm, rank, nneighbors                                                                                                        |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GROUP_COMPARE               | group1, group2, result                                                                                                        |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_DIFFERENCE            | group1, group2, newgroup                                                                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_EXCL                  | group, n, ranks, newgroup                                                                                                     |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_FREE                  | group                                                                                                                         |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_INCL                  | group, n, ranks, newgroup                                                                                                     |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_INTERSECTION          | group1, group2, newgroup                                                                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_RANGE_EXCL           | group, n, ranges, newgroup                                                                                                    |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_RANGE_INCL           | group, n, ranges, newgroup                                                                                                    |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GROUP_RANK                  | group, rank                                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GROUP_SIZE                  | group, size                                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_GROUP_TRANSLATE_RANKS      | group1, n, ranks1, group2, ranks2                                                                                             |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GROUP_UNION                 | group1, group2, newgroup                                                                                                      |
| X        |            |             |                 |              |             |          |     |      |       | MPI_IBSEND                       | buf, count, datatype, dest, tag, comm, request                                                                                |
|          |            |             |                 |              |             |          |     |      | X     | MPI_INIT                         |                                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_INITIALIZED                  | flag                                                                                                                          |
|          |            |             |                 |              |             |          | X   |      |       | MPI_INTERCOMM_CREATE            | local_comm, local_leader, peer_comm, remote_leader, tag, newintercomm                                                     |
|          |            |             |                 |              |             |          | X   |      |       | MPI_INTERCOMM_MERGE             | intercomm, high, newintracomm                                                                                                 |
| X        |            |             |                 |              |             |          |     |      |       | MPI_IPROBE                       | source, tag, comm, flag, status                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_IRECV                        | buf, count, datatype, source, tag, comm, request                                                                              |
| X        |            |             |                 |              |             |          |     |      |       | MPI_IRSEND                       | buf, count, datatype, dest, tag, comm, request                                                                                |
| X        |            |             |                 |              |             |          |     |      |       | MPI_ISEND                        | buf, count, datatype, dest, tag, comm, request                                                                                |
| X        |            |             |                 |              |             |          |     |      |       | MPI_ISSEND                       | buf, count, datatype, dest, tag, comm, request                                                                                |
|          |            |             |                 |              |             | X        |     |      |       | MPI_KEYVAL_CREATE               | copy_fn, delete_fn, keyval, extra_state                                                                                    |
|          |            |             |                 |              |             | X        |     |      |       | MPI_KEYVAL_FREE                 | keyval                                                                                                                        |
|          |            |             |                 |              |             | X        |     |      |       | MPI_OP_CREATE                   | function, commute, op                                                                                                         |
|          |            |             |                 |              |             | X        |     |      |       | MPI_OP_FREE                     | op                                                                                                                            |
|          |            | X           |                 |              |             |          |     |      |       | MPI_PACK                         | inbuf, incount, datatype, outbuf, outsize, position, comm                                                                     |
|          |            | X           |                 |              |             |          |     |      |       | MPI_PACK_SIZE                   | incount, datatype, comm, size                                                                                                 |
|          |            |             |                 |              |             |          |     | X    |       | MPI_PCONTROL                     | level, ...                                                                                                                    |
| X        |            |             |                 |              |             |          |     |      |       | MPI_PROBE                        | source, tag, comm, status                                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_RECV                         | buf, count, datatype, source, tag, comm, status                                                                               |
|          |            |             |                 |              |             | X        |     |      |       | MPI_RECV_INIT                   | buf, count, datatype, source, tag, comm, request                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_REDUCE                       | sendbuf, recvbuf, count, datatype, op, root, comm                                                                             |
|          | X          |             |                 |              |             |          |     |      |       | MPI_REDUCE_SCATTER              | sendbuf, recvbuf, recvcounts, datatype, op, comm                                                                              |
|          |            |             |                 |              |             | X        |     |      |       | MPI_REQUEST_FREE                | request                                                                                                                       |
| X        |            |             |                 |              |             |          |     |      |       | MPI_RSEND                        | buf, count, datatype, dest, tag, comm                                                                                         |
|          |            |             |                 |              |             | X        |     |      |       | MPI_RSEND_INIT                  | buf, count, datatype, dest, tag, comm, request                                                                                |
|          | X          |             |                 |              |             |          |     |      |       | MPI_SCAN                         | sendbuf, recvbuf, count, datatype, op, comm                                                                                   |
|          | X          |             |                 |              |             |          |     |      |       | MPI_SCATTER                      | sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm                                                        |
|          | X          |             |                 |              |             |          |     |      |       | MPI_SCATTERV                     | sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, recvtype, root, comm                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_SEND                         | buf, count, datatype, dest, tag, comm                                                                                         |
| X        |            |             |                 |              |             |          |     |      |       | MPI_SENDRECV                     | sendbuf, sendcount, sendtype, dest, sendtag, recvbuf, recvcount, recvtype, source, recvtag, comm, status                      |
| X        |            |             |                 |              |             |          |     |      |       | MPI_SENDRECV_REPLACE            | buf, count, datatype, dest, sendtag, source, recvtag, comm, status                                                            |
|          |            |             |                 |              |             | X        |     |      |       | MPI_SEND_INIT                   | buf, count, datatype, dest, tag, comm, request                                                                                |
| X        |            |             |                 |              |             |          |     |      |       | MPI_SSEND                        | buf, count, datatype, dest, tag, comm                                                                                         |
|          |            |             |                 |              |             | X        |     |      |       | MPI_SSEND_INIT                  | buf, count, datatype, dest, tag, comm, request                                                                                |
| X        |            |             |                 |              |             |          |     |      |       | MPI_START                        | request                                                                                                                       |
| X        |            |             |                 |              |             |          |     |      |       | MPI_STARTALL                     | count, array_of_requests                                                                                                    |
| X        |            |             |                 |              |             |          |     |      |       | MPI_TEST                         | request, flag, status                                                                                                         |
| X        |            |             |                 |              |             |          |     |      |       | MPI_TESTALL                      | count, array_of_requests, flag, array_of_statuses                                                                         |
| X        |            |             |                 |              |             |          |     |      |       | MPI_TESTANY                      | count, array_of_requests, index, flag, status                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_TESTSOME                     | incount, array_of_requests, outcount, array_of_indices, array_of_statuses                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TEST_CANCELLED              | status, flag                                                                                                                  |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TOPO_TEST                   | comm, status                                                                                                                  |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_COMMIT                 | datatype                                                                                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CONTIGUOUS             | count, oldtype, newtype                                                                                                       |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_EXTENT                 | datatype, extent                                                                                                              |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_FREE                   | datatype                                                                                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_HINDEXED               | count, array_of_blocklengths, array_of_displacements, oldtype, newtype                                                    |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_HVECTOR                | count, blocklength, stride, oldtype, newtype                                                                                  |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_INDEXED                | count, array_of_blocklengths, array_of_displacements, oldtype, newtype                                                    |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_LB                     | datatype, displacement                                                                                                        |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_SIZE                   | datatype, size                                                                                                                |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_STRUCT                 | count, array_of_blocklengths, array_of_displacements, array_of_types, newtype                                           |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_UB                     | datatype, displacement                                                                                                        |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_VECTOR                 | count, blocklength, stride, oldtype, newtype                                                                                  |
|          |            | X           |                 |              |             |          |     |      |       | MPI_UNPACK                       | inbuf, insize, position, outbuf, outcount, datatype, comm                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WAIT                         | request, status                                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WAITALL                      | count, array_of_requests, array_of_statuses                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WAITANY                      | count, array_of_requests, index, status                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WAITSOME                     | incount, array_of_requests, outcount, array_of_indices, array_of_statuses                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_WTICK                        |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_WTIME                        |                                                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_ACCUMULATE                   | origin_addr, origin_count, origin_datatype, target_rank, target_disp, target_count, target_datatype, op, win           |
|          |            |             |                 |              |             |          | X   |      |       | MPI_ADD_ERROR_CLASS            | errorclass                                                                                                                    |
|          |            |             |                 |              |             |          | X   |      |       | MPI_ADD_ERROR_CODE             | errorclass, errorcode                                                                                                         |
|          |            |             |                 |              |             |          | X   |      |       | MPI_ADD_ERROR_STRING           | errorcode, string                                                                                                             |
|          |            |             |                 |              |             |          | X   |      |       | MPI_ALLOC_MEM                   | size, info, baseptr                                                                                                           |
|          | X          |             |                 |              |             |          |     |      |       | MPI_ALLTOALLW                    | sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, rdispls, recvtypes, comm                                        |
|          |            |             |                 |              |             |          |     |      | X     | MPI_CLOSE_PORT                  | port_name                                                                                                                    |
|          | X          |             |                 |              |             |          |     |      |       | MPI_COMM_ACCEPT                 | port_name, info, root, comm, newcomm                                                                                         |
|          |            |             |                 |              |             |          |     | X    |       | MPI_COMM_C2F                    |                                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_CALL_ERRHANDLER       | comm, errorcode                                                                                                               |
|          |            |             |                 |              |             |          | X   |      |       | MPI_COMM_CLONE                  |                                                                                                                               |
|          | X          |             |                 |              |             |          |     |      |       | MPI_COMM_CONNECT                | port_name, info, root, comm, newcomm                                                                                         |
|          |            |             |                 |              |             | X        |     |      |       | MPI_COMM_CREATE_ERRHANDLER     | function, errhandler                                                                                                          |
|          |            |             |                 |              |             | X        |     |      |       | MPI_COMM_CREATE_KEYVAL         | comm_copy_attr_fn, comm_delete_attr_fn, comm_keyval, extra_state                                                      |
|          |            |             |                 |              | X           |          |     |      |       | MPI_COMM_DELETE_ATTR           | comm, comm_keyval                                                                                                            |
|          | X          |             |                 |              |             |          |     |      |       | MPI_COMM_DISCONNECT             | comm                                                                                                                          |
|          |            |             |                 |              |             |          |     | X    |       | MPI_COMM_F2C                    |                                                                                                                               |
|          |            |             |                 |              |             | X        |     |      |       | MPI_COMM_FREE_KEYVAL           | comm_keyval                                                                                                                  |
|          |            |             |                 | X            |             |          |     |      |       | MPI_COMM_GET_ATTR              | comm, comm_keyval, attribute_val, flag                                                                                      |
|          |            |             | X               |              |             |          |     |      |       | MPI_COMM_GET_ERRHANDLER        | comm, errhandler                                                                                                              |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_GET_NAME              | comm, comm_name, resultlen                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_GET_PARENT            | parent                                                                                                                        |
|          | X          |             |                 |              |             |          |     |      |       | MPI_COMM_JOIN                   | fd, intercomm                                                                                                                 |
|          |            |             |                 |              | X           |          |     |      |       | MPI_COMM_SET_ATTR              | comm, comm_keyval, attribute_val                                                                                            |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_SET_ERRHANDLER        | comm, errhandler                                                                                                              |
|          |            | X           |                 |              |             |          |     |      |       | MPI_COMM_SET_NAME              | comm, comm_name                                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_COMM_SPAWN                  | command, argv, maxprocs, info, root, comm, intercomm, array_of_errcodes                                                     |
|          | X          |             |                 |              |             |          |     |      |       | MPI_COMM_SPAWN_MULTIPLE        | count, array_of_commands, array_of_argv, array_of_maxprocs, array_of_info, root, comm, intercomm, array_of_errcodes |
|          | X          |             |                 |              |             |          |     |      |       | MPI_EXSCAN                       | sendbuf, recvbuf, count, datatype, op, comm                                                                                   |
|          |            |             |                 |              |             |          |     | X    |       | MPI_FILE_C2F                    |                                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_CALL_ERRHANDLER       | fh, errorcode                                                                                                                 |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_CLOSE                  | fh                                                                                                                            |
|          |            |             |                 |              |             | X        |     |      |       | MPI_FILE_CREATE_ERRHANDLER     | function, errhandler                                                                                                          |
|          |            |             |                 |              |             |          |     | X    |       | MPI_FILE_DELETE                 | filename, info                                                                                                                |
|          |            |             |                 |              |             |          |     | X    |       | MPI_FILE_F2C                    |                                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_AMODE             | fh, amode                                                                                                                     |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_ATOMICITY         | fh, flag                                                                                                                      |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_BYTE_OFFSET      | fh, offset, disp                                                                                                              |
|          |            |             | X               |              |             |          |     |      |       | MPI_FILE_GET_ERRHANDLER        | file, errhandler                                                                                                              |
|          |            |             | X               |              |             |          |     |      |       | MPI_FILE_GET_GROUP             | fh, group                                                                                                                     |
|          |            |             |                 |              |             | X        |     |      |       | MPI_FILE_GET_INFO              | fh, info_used                                                                                                                |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_POSITION          | fh, offset                                                                                                                    |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_POSITION_SHARED  | fh, offset                                                                                                                    |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_SIZE              | fh, size                                                                                                                      |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FILE_GET_TYPE_EXTENT      | fh, datatype, extent                                                                                                          |
|          |            |             | X               |              |             |          |     |      |       | MPI_FILE_GET_VIEW              | fh, disp, etype, filetype, datarep                                                                                            |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_IREAD                  | fh, buf, count, datatype, request                                                                                             |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_IREAD_AT              | fh, offset, buf, count, datatype, request                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_IREAD_SHARED          | fh, buf, count, datatype, request                                                                                             |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_IWRITE                 | fh, buf, count, datatype, request                                                                                             |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_IWRITE_AT             | fh, offset, buf, count, datatype, request                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_IWRITE_SHARED         | fh, buf, count, datatype, request                                                                                             |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_OPEN                   | comm, filename, amode, info, fh                                                                                               |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_PREALLOCATE            | fh, size                                                                                                                      |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_READ                   | fh, buf, count, datatype, status                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_ALL              | fh, buf, count, datatype, status                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_ALL_BEGIN       | fh, buf, count, datatype                                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_ALL_END         | fh, buf, status                                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_READ_AT               | fh, offset, buf, count, datatype, status                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_AT_ALL          | fh, offset, buf, count, datatype, status                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_AT_ALL_BEGIN   | fh, offset, buf, count, datatype                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_AT_ALL_END     | fh, buf, status                                                                                                               |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_ORDERED          | fh, buf, count, datatype, status                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_ORDERED_BEGIN   | fh, buf, count, datatype                                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_READ_ORDERED_END     | fh, buf, status                                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_READ_SHARED           | fh, buf, count, datatype, status                                                                                              |
|          |            |             |                 |              |             |          | X   |      |       | MPI_FILE_SEEK                   | fh, offset, whence                                                                                                            |
|          |            |             |                 |              |             |          | X   |      |       | MPI_FILE_SEEK_SHARED           | fh, offset, whence                                                                                                            |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_SET_ATOMICITY         | fh, flag                                                                                                                      |
|          |            |             | X               |              |             |          |     |      |       | MPI_FILE_SET_ERRHANDLER        | file, errhandler                                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_SET_INFO              | fh, info                                                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_SET_SIZE              | fh, size                                                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_SET_VIEW              | fh, disp, etype, filetype, datarep, info                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_SYNC                   | fh                                                                                                                            |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE                  | fh, buf, count, datatype, status                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_ALL             | fh, buf, count, datatype, status                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_ALL_BEGIN      | fh, buf, count, datatype                                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_ALL_END        | fh, buf, status                                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_AT              | fh, offset, buf, count, datatype, status                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_AT_ALL         | fh, offset, buf, count, datatype, status                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_AT_ALL_BEGIN  | fh, offset, buf, count, datatype                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_AT_ALL_END    | fh, buf, status                                                                                                               |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_ORDERED         | fh, buf, count, datatype, status                                                                                              |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_ORDERED_BEGIN  | fh, buf, count, datatype                                                                                                      |
|          | X          |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_ORDERED_END    | fh, buf, status                                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_FILE_WRITE_SHARED          | fh, buf, count, datatype, status                                                                                              |
|          |            | X           |                 |              |             |          |     |      |       | MPI_FINALIZED                    | flag                                                                                                                          |
|          |            |             |                 |              |             |          | X   |      |       | MPI_FREE_MEM                    | base                                                                                                                          |
| X        |            |             |                 |              |             |          |     |      |       | MPI_GET                          | origin_addr, origin_count, origin_datatype, target_rank, target_disp, target_count, target_datatype, win               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_GET_ADDRESS                 | location, address                                                                                                             |
|          |            |             |                 |              |             |          |     | X    |       | MPI_GET_VERSION                 | version, subversion                                                                                                           |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GREQUEST_COMPLETE           | request                                                                                                                       |
|          |            |             |                 |              |             | X        |     |      |       | MPI_GREQUEST_START              | query_fn, free_fn, cancel_fn, extra_state, request                                                                        |
|          |            |             |                 |              |             |          |     | X    |       | MPI_GROUP_C2F                   |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_GROUP_F2C                   |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_INFO_C2F                    |                                                                                                                               |
|          |            |             |                 |              |             | X        |     |      |       | MPI_INFO_CREATE                 | info                                                                                                                          |
|          |            |             |                 |              | X           |          |     |      |       | MPI_INFO_DELETE                 | info, key                                                                                                                     |
|          |            |             |                 |              |             | X        |     |      |       | MPI_INFO_DUP                    | info, newinfo                                                                                                                 |
|          |            |             |                 |              |             |          |     | X    |       | MPI_INFO_F2C                    |                                                                                                                               |
|          |            |             |                 |              |             | X        |     |      |       | MPI_INFO_FREE                   | info                                                                                                                          |
|          |            |             |                 | X            |             |          |     |      |       | MPI_INFO_GET                    | info, key, valuelen, value, flag                                                                                              |
|          |            |             |                 | X            |             |          |     |      |       | MPI_INFO_GET_NKEYS             | info, nkeys                                                                                                                   |
|          |            |             |                 | X            |             |          |     |      |       | MPI_INFO_GET_NTHKEY            | info, n, key                                                                                                                  |
|          |            |             |                 | X            |             |          |     |      |       | MPI_INFO_GET_VALUELEN          | info, key, valuelen, flag                                                                                                     |
|          |            |             |                 |              | X           |          |     |      |       | MPI_INFO_SET                    | info, key, value                                                                                                              |
|          |            |             |                 |              |             |          |     |      | X     | MPI_INIT_THREAD                 | required, provided                                                                                                            |
|          |            |             |                 |              |             |          |     | X    |       | MPI_IS_THREAD_MAIN             | flag                                                                                                                          |
|          |            |             |                 |              |             |          |     | X    |       | MPI_LOOKUP_NAME                 | service_name, info, port_name                                                                                               |
|          |            |             |                 |              |             |          | X   |      |       | MPI_OPEN_PORT                   | info, port_name                                                                                                              |
|          |            |             |                 |              |             |          |     | X    |       | MPI_OP_C2F                      |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_OP_F2C                      |                                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_PACK_EXTERNAL               | datarep, inbuf, incount, datatype, outbuf, outsize, position                                                                  |
|          |            |             |                 |              |             |          |     | X    |       | MPI_PACK_EXTERNAL_SIZE         | datarep, incount, datatype, size                                                                                              |
|          |            |             |                 |              |             |          | X   |      |       | MPI_PUBLISH_NAME                | service_name, info, port_name                                                                                               |
| X        |            |             |                 |              |             |          |     |      |       | MPI_PUT                          | origin_addr, origin_count, origin_datatype, target_rank, target_disp, target_count, target_datatype, win               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_QUERY_THREAD                | provided                                                                                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_REGISTER_DATAREP            | datarep, read_conversion_fn, write_conversion_fn, dtype_file_extent_fn, extra_state                                   |
|          |            |             |                 |              |             |          |     | X    |       | MPI_REQUEST_C2F                 |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_REQUEST_F2C                 |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_REQUEST_GET_STATUS         | request, flag, status                                                                                                         |
|          |            |             |                 |              |             |          |     | X    |       | MPI_SIZEOF                       | x, size                                                                                                                       |
|          |            |             |                 |              |             |          |     | X    |       | MPI_STATUS_C2F                  |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_STATUS_F2C                  |                                                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_STATUS_SET_CANCELLED       | status, flag                                                                                                                  |
|          |            |             |                 |              |             |          |     | X    |       | MPI_STATUS_SET_ELEMENTS        | status, datatype, count                                                                                                       |
|          |            |             |                 |              |             |          |     | X    |       | MPI_TYPE_C2F                    |                                                                                                                               |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_DARRAY         | size, rank, ndims, array_of_gsizes, array_of_distribs, array_of_dargs, array_of_psizes, order, oldtype, newtype       |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_F90_COMPLEX   | p, r, newtype                                                                                                                 |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_F90_INTEGER   | r, newtype                                                                                                                    |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_F90_REAL      | p, r, newtype                                                                                                                 |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_HINDEXED       | count, array_of_blocklengths, array_of_displacements, oldtype, newtype                                                    |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_HVECTOR        | count, blocklength, stride, oldtype, newtype                                                                                  |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_INDEXED_BLOCK | count, blocklength, array_of_displacements, oldtype, newtype                                                                |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_KEYVAL         | type_copy_attr_fn, type_delete_attr_fn, type_keyval, extra_state                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_RESIZED        | oldtype, lb, extent, newtype                                                                                                  |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_STRUCT         | count, array_of_blocklengths, array_of_displacements, array_of_types, newtype                                           |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_CREATE_SUBARRAY       | ndims, array_of_sizes, array_of_subsizes, array_of_starts, order, oldtype, newtype                                      |
|          |            |             |                 |              | X           |          |     |      |       | MPI_TYPE_DELETE_ATTR           | type, type_keyval                                                                                                            |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_DUP                    | type, newtype                                                                                                                 |
|          |            |             |                 |              |             |          |     | X    |       | MPI_TYPE_F2C                    |                                                                                                                               |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_FREE_KEYVAL           | type_keyval                                                                                                                  |
|          |            |             |                 | X            |             |          |     |      |       | MPI_TYPE_GET_ATTR              | type, type_keyval, attribute_val, flag                                                                                      |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_GET_CONTENTS          | datatype, max_integers, max_addresses, max_datatypes, array_of_integers, array_of_addresses, array_of_datatypes      |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_GET_ENVELOPE          | datatype, num_integers, num_addresses, num_datatypes, combiner                                                             |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_GET_EXTENT            | datatype, lb, extent                                                                                                          |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_GET_NAME              | type, type_name, resultlen                                                                                                   |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_GET_TRUE_EXTENT      | datatype, true_lb, true_extent                                                                                              |
|          |            |             |                 |              |             | X        |     |      |       | MPI_TYPE_MATCH_SIZE            | typeclass, size, type                                                                                                         |
|          |            |             |                 |              | X           |          |     |      |       | MPI_TYPE_SET_ATTR              | type, type_keyval, attribute_val                                                                                            |
|          |            | X           |                 |              |             |          |     |      |       | MPI_TYPE_SET_NAME              | type, type_name                                                                                                              |
|          |            | X           |                 |              |             |          |     |      |       | MPI_UNPACK_EXTERNAL             | datarep, inbuf, incount, datatype, outbuf, outsize, position                                                                  |
|          |            |             |                 |              |             |          | X   |      |       | MPI_UNPUBLISH_NAME              | service_name, info, port_name                                                                                               |
|          |            |             |                 |              |             |          |     | X    |       | MPI_WIN_C2F                     |                                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_WIN_CALL_ERRHANDLER        | win, errorcode                                                                                                                |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_COMPLETE                | win                                                                                                                           |
|          | X          |             |                 |              |             |          |     |      |       | MPI_WIN_CREATE                  | base, size, disp_unit, info, comm, win                                                                                       |
|          |            |             |                 |              |             | X        |     |      |       | MPI_WIN_CREATE_ERRHANDLER      | function, errhandler                                                                                                          |
|          |            |             |                 |              |             | X        |     |      |       | MPI_WIN_CREATE_KEYVAL          | win_copy_attr_fn, win_delete_attr_fn, win_keyval, extra_state                                                         |
|          |            |             |                 |              | X           |          |     |      |       | MPI_WIN_DELETE_ATTR            | win, win_keyval                                                                                                              |
|          |            |             |                 |              |             |          |     | X    |       | MPI_WIN_F2C                     |                                                                                                                               |
|          | X          |             |                 |              |             |          |     |      |       | MPI_WIN_FENCE                   | assert, win                                                                                                                   |
|          | X          |             |                 |              |             |          |     |      |       | MPI_WIN_FREE                    | win                                                                                                                           |
|          |            |             |                 |              |             | X        |     |      |       | MPI_WIN_FREE_KEYVAL            | win_keyval                                                                                                                   |
|          |            |             |                 | X            |             |          |     |      |       | MPI_WIN_GET_ATTR               | win, win_keyval, attribute_val, flag                                                                                        |
|          |            |             | X               |              |             |          |     |      |       | MPI_WIN_GET_ERRHANDLER         | win, errhandler                                                                                                               |
|          |            |             | X               |              |             |          |     |      |       | MPI_WIN_GET_GROUP              | win, group                                                                                                                    |
|          |            | X           |                 |              |             |          |     |      |       | MPI_WIN_GET_NAME               | win, win_name, resultlen                                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_LOCK                    | lock_type, rank, assert, win                                                                                                 |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_POST                    | group, assert, win                                                                                                            |
|          |            |             |                 |              | X           |          |     |      |       | MPI_WIN_SET_ATTR               | win, win_keyval, attribute_val                                                                                              |
|          |            |             | X               |              |             |          |     |      |       | MPI_WIN_SET_ERRHANDLER         | win, errhandler                                                                                                               |
|          |            | X           |                 |              |             |          |     |      |       | MPI_WIN_SET_NAME               | win, win_name                                                                                                                |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_START                   | group, assert, win                                                                                                            |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_TEST                    | win, flag                                                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_UNLOCK                  | rank, win                                                                                                                     |
| X        |            |             |                 |              |             |          |     |      |       | MPI_WIN_WAIT                    | win                                                                                                                           |

**Explanation of Categories in the table of Thread Safety Needs of MPI
Routines**

  - **Comm/IO:** The routine needs to access the communication or I/O
    system in a thread-safe way. This is a very coarse-grained category
    but is sufficient to provide thread safety. In other words, an
    implementation may (and probably should) use finer-grained controls
    within this category.
  - **Collective:** Collective routines require that the user not call
    collectives on the same communicator in different threads in a way
    that my make the order of invocation depend on thread timing (race).
    A production MPI need not separately lock around the collective
    routines but a debug version may want to detect races. The
    communication part of the collective routine is assumed to be
    handled separately through the communication thread locks
  - **Access Only** Access fixed data for an MPI object, such as the
    size of a communicator. This differs from the "none" case because an
    erroneous MPI program could free the object in a race with a routine
    that accesses the read-only data. A production MPI implementation
    need not guard this routine against changes in another thread. This
    may also include replacing a value within a routine, such as setting
    the name of a communicator.
  - **Update Ref:** Update the reference count of an MPI object only.
    Typically used by a routine that returns a reference to an internal
    object, such as an errhandler or datatype.
  - **Read List:** Return an element from a list of items, such as an
    attribute or info value. A correct MPI program will not contain any
    race that might update or delete the entry that is being read. This
    allows the implementation to use a lock-free, thread-safe set of
    list update and access operations in the production version; a debug
    version can attempt to detect improper race conditions
  - **Update List:** Update a list of items that may also be read (see
    the Read List entry). Multiple thread are allowed to simultaneously
    update the list, so the update implementation must be thread safe.
  - **Allocate:** Allocate an MPI object (may also need memory
    allocation such as malloc)
  - **Own:** The routine has its own thread-safety management. Examples
    are "global" state such as bsend buffers
  - **None:** The routine has no thread safety issues, or the routine
    has no thread-safety issues in correct programs and the routine must
    have low overhead and so an optimized (non-debug) version need not
    check for race conditions.
  - **Other:** Special cases, such as MPI_Abort and MPI_Finalize

Some routines fall into multiple categories; only the "major" category
is marked. For example, the communicator creation routines must all
access the global state for the context id, this has marked them in the
"Own" category. They also are relevant for the "Collective" and "Access
Only" categories.
