import { SkipAfterProperty } from '../property/SkipAfterProperty.js';
import { TimeoutProperty } from '../property/TimeoutProperty.js';
import { UnbiasedProperty } from '../property/UnbiasedProperty.js';
export function decorateProperty(rawProperty, qParams) {
    var prop = rawProperty;
    if (rawProperty.isAsync() && qParams.timeout != null)
        prop = new TimeoutProperty(prop, qParams.timeout);
    if (qParams.unbiased === true)
        prop = new UnbiasedProperty(prop);
    if (qParams.skipAllAfterTimeLimit != null)
        prop = new SkipAfterProperty(prop, Date.now, qParams.skipAllAfterTimeLimit, false);
    if (qParams.interruptAfterTimeLimit != null)
        prop = new SkipAfterProperty(prop, Date.now, qParams.interruptAfterTimeLimit, true);
    return prop;
}
