/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.lang.reflect.Method;
import org.apache.turbine.om.Retrievable;
import org.apache.turbine.services.intake.TurbineIntake;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.services.intake.validator.Validator;
import org.apache.turbine.services.intake.xmlmodel.Rule;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public abstract class Field {
    private static final String EMPTY = "";
    private static final String VALUE_IF_ABSENT_KEY = "_vifa_";
    protected final String name;
    protected final String key;
    protected final String mapToObject;
    protected Validator validator;
    protected final Method getter;
    protected final Method setter;
    protected final String ifRequiredMessage;
    protected final boolean isMultiValued;
    protected final Group group;
    protected boolean alwaysRequired;
    protected Object onError;
    protected boolean set_flag;
    protected boolean valid_flag;
    protected boolean required;
    protected boolean initialized;
    protected String message;
    protected Retrievable retrievable;
    private Object validValue;
    private Object testValue;
    private String propertyName;
    private Object[] valArray;
    protected RunData data;

    /*
     * Enabled aggressive block sorting
     */
    public Field init(RunData data) throws TurbineException {
        this.data = data;
        this.valid_flag = true;
        ParameterParser pp = data.getParameters();
        if (pp.containsKey(this.getKey()) && pp.getString(this.getKey()) != null) {
            this.set_flag = true;
            if (!this.validate(pp)) {
                // empty if block
            }
        } else if (pp.containsKey(this.getValueIfAbsent()) && pp.getString(this.getValueIfAbsent()) != null) {
            pp.add(this.getKey(), pp.getString(this.getValueIfAbsent()));
            this.set_flag = true;
            this.validate(pp);
        }
        this.initialized = true;
        return this;
    }

    public Field init(Retrievable obj) {
        if (!this.initialized) {
            this.valid_flag = true;
        }
        this.retrievable = obj;
        return this;
    }

    protected String getDefaultValidator() {
        return "org.apache.turbine.services.intake.validator.DefaultValidator";
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean isRequired() {
        return this.alwaysRequired || this.required;
    }

    public void setRequired(boolean v) {
        this.setRequired(v, this.ifRequiredMessage);
    }

    public void setRequired(boolean v, String message) {
        this.required = v;
        if (v && !this.set_flag) {
            this.valid_flag = false;
            this.message = message;
        }
    }

    public void removeFromRequest() {
        this.data.getParameters().remove(this.getKey());
    }

    public void dispose() {
        this.data = null;
        this.initialized = false;
        this.set_flag = false;
        this.valid_flag = false;
        this.required = false;
        this.message = null;
        this.validValue = null;
        this.testValue = null;
        this.valArray[0] = null;
    }

    public String getKey() {
        if (this.group == null) {
            return this.key;
        }
        return this.group.getObjectKey() + this.key;
    }

    public String getValueIfAbsent() {
        return this.getKey() + VALUE_IF_ABSENT_KEY;
    }

    public boolean isValid() {
        return this.valid_flag;
    }

    public boolean isSet() {
        return this.set_flag;
    }

    public String getMessage() {
        if (this.message == null) {
            return EMPTY;
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.valid_flag = false;
    }

    protected boolean validate(ParameterParser pp) {
        if (this.isMultiValued) {
            String[] ss = pp.getStrings(this.getKey());
            if (ss.length == 0 || ss.length == 1 && ss[0].length() == 0) {
                this.set_flag = false;
            }
            int i = 0;
            while (i < ss.length) {
                if (this.validator != null) {
                    try {
                        this.validator.assertValidity(ss[i]);
                    }
                    catch (ValidationException ve) {
                        this.setMessage(ve.getMessage());
                    }
                }
                ++i;
            }
        } else {
            String s = pp.getString(this.getKey());
            if (s.length() == 0) {
                this.set_flag = false;
            }
            if (this.validator != null) {
                try {
                    this.validator.assertValidity(s);
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            }
        }
        if (this.set_flag) {
            this.doSetValue(pp);
        }
        return this.valid_flag;
    }

    protected abstract void doSetValue(ParameterParser var1);

    void setInitialValue(Object obj) {
        this.validValue = obj;
    }

    public Object getInitialValue() throws Exception {
        if (this.validValue == null && this.retrievable != null) {
            this.getProperty(this.retrievable);
        }
        return this.validValue;
    }

    void setTestValue(Object obj) {
        this.testValue = obj;
    }

    public Object getTestValue() {
        return this.testValue;
    }

    public Object getValue() {
        Object val = null;
        try {
            val = this.getInitialValue();
        }
        catch (Exception e) {
            Log.error(e);
        }
        if (this.getTestValue() != null) {
            val = this.getTestValue();
        }
        if (val == null) {
            val = this.onError;
        }
        return val;
    }

    public String toString() {
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return EMPTY;
    }

    public void getProperty(Object obj) throws Exception {
        this.validValue = this.getter.invoke(obj, null);
    }

    public void setProperty(Object obj) throws TurbineException {
        if (!this.isValid()) {
            throw new TurbineException("Attempted to assign an invalid input.");
        }
        if (this.isSet()) {
            try {
                this.valArray[0] = this.getTestValue();
                this.setter.invoke(obj, this.valArray);
            }
            catch (Exception e) {
                throw new TurbineException("An exception prevented the mapping to " + obj, e);
            }
        }
    }

    public Field(XmlField field, Group group) throws Exception {
        Rule reqRule;
        this.group = group;
        this.key = field.getKey();
        this.name = field.getName();
        this.isMultiValued = field.isMultiValued();
        String className = field.getValidator();
        if (className == null && field.getRules().size() > 0) {
            className = this.getDefaultValidator();
        } else if (className != null && className.indexOf(46) == -1) {
            className = "org.apache.turbine.services.intake.validator." + className;
        }
        if (className != null) {
            this.validator = (Validator)Class.forName(className).newInstance();
            this.validator.init(field.getRuleMap());
        }
        if ((reqRule = (Rule)field.getRuleMap().get("required")) != null) {
            this.alwaysRequired = new Boolean(reqRule.getValue());
        }
        this.mapToObject = field.getMapToObject();
        String propName = field.getMapToProperty();
        Method tmpGetter = null;
        Method tmpSetter = null;
        if (this.mapToObject != null && this.mapToObject.length() != 0) {
            tmpGetter = TurbineIntake.getFieldGetter(this.mapToObject, propName);
            tmpSetter = TurbineIntake.getFieldSetter(this.mapToObject, propName);
        }
        this.getter = tmpGetter;
        this.setter = tmpSetter;
        this.ifRequiredMessage = field.getIfRequiredMessage();
        this.valArray = new Object[1];
    }
}

