// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CUSTOMIZE_THEMES_CHROME_CUSTOMIZE_THEMES_HANDLER_H_
#define CHROME_BROWSER_UI_WEBUI_CUSTOMIZE_THEMES_CHROME_CUSTOMIZE_THEMES_HANDLER_H_

#include "base/memory/raw_ptr.h"
#include "chrome/browser/themes/theme_service_observer.h"
#include "mojo/public/cpp/bindings/pending_receiver.h"
#include "mojo/public/cpp/bindings/pending_remote.h"
#include "mojo/public/cpp/bindings/receiver.h"
#include "mojo/public/cpp/bindings/remote.h"
#include "ui/webui/resources/cr_components/customize_themes/customize_themes.mojom.h"

namespace chrome_colors {
class ChromeColorsService;
}

namespace content {
class WebContents;
}

class Profile;
class ThemeService;

// Implementation of the customize_themes::mojom::CustomizeThemesHandler
// interface.
//
// Supports profile theme changes originating from the CustomizeThemesHandler
// remote, by utilizing ChromeColorsService. Notifies the CustomizeThemesClient
// receiver about all theme updates in the current profile.
class ChromeCustomizeThemesHandler
    : public customize_themes::mojom::CustomizeThemesHandler,
      public ThemeServiceObserver {
 public:
  explicit ChromeCustomizeThemesHandler(
      mojo::PendingRemote<customize_themes::mojom::CustomizeThemesClient>
          pending_client,
      mojo::PendingReceiver<customize_themes::mojom::CustomizeThemesHandler>
          pending_handler,
      content::WebContents* web_contents,
      Profile* profile);
  ~ChromeCustomizeThemesHandler() override;

  // customize_themes::mojom::CustomizeThemesHandler:
  void ApplyAutogeneratedTheme(SkColor frame_color) override;
  void ApplyDefaultTheme() override;
  void ApplyChromeTheme(int32_t id) override;
  void InitializeTheme() override;
  void GetChromeThemes(GetChromeThemesCallback callback) override;
  void ConfirmThemeChanges() override;
  void RevertThemeChanges() override;

  // ThemeServiceObserver:
  void OnThemeChanged() override;

 private:
  void UpdateTheme();

  mojo::Remote<customize_themes::mojom::CustomizeThemesClient> remote_client_;
  mojo::Receiver<customize_themes::mojom::CustomizeThemesHandler> receiver_;

  const raw_ptr<content::WebContents> web_contents_;
  const raw_ptr<Profile> profile_;
  const raw_ptr<chrome_colors::ChromeColorsService> chrome_colors_service_;
  const raw_ptr<ThemeService> theme_service_;
};

#endif  // CHROME_BROWSER_UI_WEBUI_CUSTOMIZE_THEMES_CHROME_CUSTOMIZE_THEMES_HANDLER_H_
