% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doby_utilities.R
\name{which.maxn}
\alias{which.maxn}
\alias{which.minn}
\title{Where are the n largest or n smallest elements in a numeric vector ?}
\usage{
which.maxn(x, n = 1)
}
\arguments{
\item{x}{numeric vector}

\item{n}{integer >= 1}
}
\value{
A vector of length at most n with the indices of the n largest /
smaller elements. NAs are discarded and that can cause the vector to be
smaller than n.
}
\description{
Determines the locations, i.e., indices of the n largest or n smallest
elements of a numeric vector.
}
\examples{

x <- c(1:4, 0:5, 11, NA, NA)
ii <- which.minn(x, 5)

x <- c(1, rep(NA,10), 2)
ii <- which.minn(x, 5)

}
\seealso{
\code{\link{which.max}}, \code{\link{which.min}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
