# -*- coding: utf-8 -*-
# Copyright 2025 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the nxos_l2_interfaces module
"""


class L2_interfacesArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_l2_interfaces module"""

    argument_spec = {
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "name": {"type": "str", "required": True},
                "access": {"type": "dict", "options": {"vlan": {"type": "int"}}},
                "trunk": {
                    "type": "dict",
                    "options": {
                        "native_vlan": {"type": "int"},
                        "allowed_vlans": {"type": "str"},
                    },
                },
                "mode": {
                    "type": "str",
                    "choices": [
                        "dot1q-tunnel",
                        "access",
                        "trunk",
                        "fex-fabric",
                        "fabricpath",
                    ],
                },
                "cdp_enable": {"type": "bool"},
                "link_flap": {
                    "type": "dict",
                    "options": {
                        "error_disable": {
                            "type": "dict",
                            "options": {
                                "count": {"type": "int"},
                                "interval": {"type": "int"},
                            },
                        },
                    },
                },
                "beacon": {"type": "bool"},
            },
        },
        "state": {
            "type": "str",
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
        "running_config": {"type": "str"},
    }  # pylint: disable=C0301
