namespace Board {

#include "linear.cpp"
#include "split.cpp"
#include "banked.cpp"
#include "ram.cpp"
#include "system-card.cpp"
#include "super-system-card.cpp"
#include "arcade-card-duo.cpp"
#include "arcade-card-pro.cpp"
#include "games-express.cpp"
#include "debugger.cpp"

auto Interface::load(Memory::Readable<n8>& memory, string name) -> bool {
  if(auto fp = pak->read(name)) {
    memory.allocate(fp->size());
    memory.load(fp);
    return true;
  }
  return false;
}

auto Interface::load(Memory::Writable<n8>& memory, string name) -> bool {
  if(auto fp = pak->read(name)) {
    memory.allocate(fp->size());
    memory.load(fp);
    return true;
  }
  return false;
}

auto Interface::save(Memory::Writable<n8>& memory, string name) -> bool {
  if(auto fp = pak->write(name)) {
    memory.save(fp);
    return true;
  }
  return false;
}

}
