/* Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef ECMA_NUMBER_ARITHMETIC_H
#define ECMA_NUMBER_ARITHMETIC_H

#include "ecma-globals.h"

/** \addtogroup ecma ECMA
 * @{
 *
 * \addtogroup numberarithmetic ECMA number arithmetic operations
 * @{
 */

ecma_number_t ecma_op_number_remainder (ecma_number_t left_num, ecma_number_t right_num);

/**
 * @}
 * @}
 */

#endif /* !ECMA_NUMBER_ARITHMETIC_H */
