/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_QML_HUD
#define UBUNTU_HUD_QML_HUD

#include "../src/hud.h"
#include "context.h"

#include <QQmlListProperty>

namespace Ubuntu {
namespace HUD {
namespace QML {
    class HUD;
}
}
}

class Ubuntu::HUD::QML::HUD : public Ubuntu::HUD::HUD
{
    Q_OBJECT

    Q_PROPERTY(QQmlListProperty<Ubuntu::HUD::QML::Context> contexts
               READ contexts_list);

    /** can be set only once.
     *  must not be ""
     * when set, application registeres to HUD
     */
    Q_PROPERTY(QString applicationIdentifier
               READ applicationIdentifier
               WRITE setApplicationIdentifier
               NOTIFY applicationIdentifierChanged)

    Q_CLASSINFO("DefaultProperty", "contexts");

    class Private;

public:

    HUD(QObject *parent = 0);
    virtual ~HUD();

    QQmlListProperty<Context> contexts_list();

signals:
    void applicationIdentifierChanged(const QString &identifier);

private:

    static void append(QQmlListProperty<Context> *list, Context *context);
    static Context *at(QQmlListProperty<Context> *list, int index);
    static void clear(QQmlListProperty<Context> *list);
    static int count(QQmlListProperty<Context> *list);

    QString applicationIdentifier() const;
    void setApplicationIdentifier(const QString &identifier);

    Private *d;
};

#endif // UBUNTU_HUD_QML_HUD
