/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_PARAMETER_H
#define UBUNTU_HUD_PARAMETER_H

#include <QObject>
#include <QVariant>

namespace Ubuntu {
namespace HUD {
    class Parameter;
    class Action;
}
}

class Ubuntu::HUD::Parameter : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(Parameter)

    Q_PROPERTY(QString type
               READ type
               WRITE setType
               NOTIFY typeChanged)

    Q_PROPERTY(QVariant defaultValue
               READ defaultValue)
    Q_PROPERTY(QVariant currentValue
               READ currentValue)
    Q_PROPERTY(QString name
               READ name)

    class Private;

public:
    explicit Parameter(QObject *parent = 0);
    virtual ~Parameter();

    /*!
     * type of the parameter, int, color whatever..
     * should also hint about the type of widget to be used in HUD
     */
    QString type() const;
    void setType(const QString &type);

    /*! default value for the parameter to do reset or to use as initial value */
    QVariant defaultValue();
    QVariant currentValue();
    QString name() const;

protected:
    friend class Ubuntu::HUD::Action;
    virtual void magic(void **menuitem, void **gaction) = 0; // search action.cpp for documentation

signals:
    /*! do we need this? in theory we could just hook to the currentValueChanged
     * signals. But still.. Might not be feasible with actual C++...
     */
    void updated();
    void typeChanged(const QString &type);

private:
    Private *d;
};

#endif // UBUNTU_HUD_PARAMETER_H
