/* This file is part of libhud-qt
 * Copyright 2013 Canonical Ltd.
 *
 * libhud-qt is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * libhud-qt is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBUNTU_HUD_SLIDER_PARAMETER_H
#define UBUNTU_HUD_SLIDER_PARAMETER_H

#include "parameter.h"

namespace Ubuntu {
namespace HUD {
    class SliderParameter;
}
}

class Ubuntu::HUD::SliderParameter : public Ubuntu::HUD::Parameter
{
    Q_OBJECT

    Q_PROPERTY(float minimumValue
               READ minimumValue
               WRITE setMinimumValue
               NOTIFY minimumValueChanged)

    Q_PROPERTY(float maximumValue
               READ maximumValue
               WRITE setMaximumValue
               NOTIFY maximumValueChanged)

    Q_PROPERTY(float stepSize
               READ stepSize
               WRITE setStepSize
               NOTIFY stepSizeChanged)

    Q_PROPERTY(float value
               READ value
               WRITE setValue
               NOTIFY valueChanged)

    Q_PROPERTY(bool live
               READ live
               WRITE setLive
               NOTIFY liveChanged)

    Q_PROPERTY(QString label
               READ label
               WRITE setLabel
               NOTIFY labelChanged)

    class Private;

public:

    SliderParameter(QObject *parent = 0);
    ~SliderParameter();

    float minimumValue() const;
    void setMinimumValue(float value);

    float maximumValue() const;
    void setMaximumValue(float value);

    float stepSize() const;
    void setStepSize(float value);

    float value() const;
    void setValue(float value);

    bool live() const;
    void setLive(bool value);

    /*! user visible label of the parameter */
    QString label() const;
    void setLabel(const QString &label);

signals:
    void minimumValueChanged(float value);
    void maximumValueChanged(float value);
    void stepSizeChanged(float value);
    void valueChanged(float value);
    void liveChanged(bool value);    
    void labelChanged(const QString &label);

private:
    virtual void magic(void **menuitem, void **gaction);

private:
    Private *d;
};


#endif // UBUNTU_HUD_SLIDER_PARAMETER_H
