package org.jboss.cache.passivation;

import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

/**
 * tests passivation using file cache loader
 *
 * @author <a href="mailto:{hmesha@novell.com}">{Hany Mesha}</a>
 * @version $Id: PassivationToFileCacheLoaderTest.java 4444 2007-08-28 14:40:21Z jason.greene@jboss.com $
 */
public class PassivationToFileCacheLoaderTest extends PassivationTestsBase
{


   protected void configureCache() throws Exception
   {

      String tmp_location = null;
      String OS = System.getProperty("os.name").toLowerCase();
      if (OS.contains("win") || OS.contains("nt"))
      {
         tmp_location = System.getProperty("java.io.tmpdir", "c:\\tmp");
      }
      else
      {
         tmp_location = System.getProperty("jva.io.tmpdir", "/tmp");
      }

      cache.getConfiguration().setCacheLoaderConfig(getCacheLoaderConfig(tmp_location));
   }

   protected CacheLoaderConfig getCacheLoaderConfig(String loc) throws Exception
   {
      String xml = "            <config>\n" +
              "                \n" +
              "                <passivation>true</passivation>\n" +
              "                <preload></preload>\n" +
              "\n" +
              "                <cacheloader>\n" +
              "                    <class>org.jboss.cache.loader.FileCacheLoader</class>\n" +
              "                    <properties>\n" +
              "                    </properties>\n" +
              "                    <async>false</async>\n" +
              "                    <fetchPersistentState>false</fetchPersistentState>\n" +
              "                    <ignoreModifications>false</ignoreModifications>\n" +
              "                </cacheloader>\n" +
              "                \n" +
              "            </config>";
      Element element = XmlHelper.stringToElement(xml);
      return XmlConfigurationParser.parseCacheLoaderConfig(element);
   }

}
