/* ----- encode/653xfreeze3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_653xfreeze3_checksums[] = {
  "2af9cde3800c6d3ab447ef1153b456f24387915970704887562d60dba892d8ea",
  "a4142003bb2d13fc4e6fb515d06420bd4304cfae48831b80fe21ca6665e41701",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_653xfreeze3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_653xfreeze3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_653xfreeze3_ITEMBYTES

static void *storage_encode_653xfreeze3_s;
static unsigned char *test_encode_653xfreeze3_s;
static void *storage_encode_653xfreeze3_x;
static unsigned char *test_encode_653xfreeze3_x;
static void *storage_encode_653xfreeze3_s2;
static unsigned char *test_encode_653xfreeze3_s2;
static void *storage_encode_653xfreeze3_x2;
static unsigned char *test_encode_653xfreeze3_x2;

#define precomputed_encode_653xfreeze3_NUM 4

static const unsigned char precomputed_encode_653xfreeze3_s[precomputed_encode_653xfreeze3_NUM][crypto_encode_STRBYTES] = {
  {0,0,255,0,1,0,255,255,2,0,0,1,255,0,2,255,254,0,255,255,0,0,254,1,0,255,255,255,0,1,1,1,0,254,255,255,255,255,0,254,0,0,254,254,2,254,0,254,254,1,0,1,0,2,255,2,1,0,0,255,255,1,1,0,0,255,1,0,1,0,1,0,255,255,1,255,0,255,254,0,254,0,0,255,1,255,254,255,255,0,255,255,0,1,1,0,1,0,255,2,2,255,255,0,255,0,0,255,0,1,1,0,0,0,1,0,0,2,255,0,0,255,0,1,0,254,0,1,255,0,255,255,1,255,0,255,255,1,0,0,2,1,0,1,0,255,0,1,255,1,0,0,1,1,1,0,1,0,255,2,255,255,1,1,255,0,255,255,0,2,0,255,0,0,2,0,2,0,0,255,0,0,255,0,1,254,1,1,255,1,255,0,0,0,255,0,0,255,0,0,1,0,255,0,1,254,0,255,0,255,255,0,1,2,255,0,255,0,255,1,255,1,2,254,255,1,0,1,0,0,0,255,2,254,0,0,1,255,255,0,255,1,0,0,1,254,255,1,0,0,0,0,255,0,0,1,1,2,0,1,1,254,1,0,1,0,254,255,0,255,2,1,1,255,255,255,0,0,1,0,254,1,255,1,1,2,255,255,255,255,1,254,1,254,0,0,0,255,255,255,0,0,0,0,0,2,0,0,1,255,255,255,0,255,0,2,0,0,255,255,2,1,255,254,255,1,0,255,255,1,1,1,0,255,0,1,0,0,255,255,0,1,255,0,2,255,255,1,0,255,0,255,1,1,255,0,254,1,1,0,255,0,255,255,255,254,0,2,255,2,0,255,0,255,254,255,0,255,1,1,0,0,255,0,0,0,2,1,0,254,1,0,255,2,1,254,0,1,0,254,2,0,255,0,0,0,255,0,0,1,0,1,1,254,255,0,1,1,0,255,1,254,254,1,0,0,2,0,1,0,255,254,0,254,2,0,255,254,0,255,254,0,1,1,0,1,0,0,0,1,255,0,0,1,2,255,1,255,0,255,0,255,1,1,0,255,0,1,1,1,2,1,255,0,1,1,255,0,2,2,254,0,1,255,255,0,255,2,2,255,255,2,1,0,255,1,2,2,255,0,1,1,1,255,254,1,0,255,255,255,255,254,0,0,254,255,255,254,1,1,254,2,2,255,2,0,0,0,2,254,0,0,255,255,255,255,0,0,255,0,255,255,0,255,1,0,1,1,255,255,2,254,1,1,254,0,255,1,0,0,1,1,1,1,255,255,0,1,254,1,0,255,2,0,0,1,0,1,1,254,255,1,1,0,0,1,255,1,255,0,0,0,0,255,0,0,1,255,255,2,255,255,254,1,1,2,1,255,0,0,0,0,255,1,0,1,1,0,255,0,0,255,0,255,0,255,0,1,0,0,0,1,255,254,0,1,1,255,254,1,255,0,255,0,255,0,1,1,0,254,255,1,255},
  {0,254,1,0,1,255,1,0,1,1,0,255,255,255,2,1,254,1,255,1,1,255,1,0,255,255,0,255,0,1,255,255,0,0,2,0,0,255,0,0,0,1,254,1,255,0,255,255,1,0,1,0,2,255,2,1,255,2,1,1,0,1,2,255,0,255,0,0,255,255,1,1,0,0,1,2,255,1,255,255,0,1,2,0,1,255,255,0,255,255,0,254,255,0,1,255,0,1,1,255,255,2,1,255,255,254,2,1,0,255,0,1,255,0,255,1,254,255,254,1,1,1,0,1,0,0,0,1,254,1,1,255,0,1,1,2,2,0,255,1,0,255,0,0,255,1,0,1,2,255,254,0,1,2,255,0,0,0,0,2,1,255,2,1,2,1,1,0,0,255,0,255,0,1,0,255,2,255,255,1,0,0,255,1,255,1,1,1,255,0,255,1,255,0,0,255,0,0,255,255,255,0,255,0,255,0,1,1,1,0,0,0,0,1,255,0,0,255,255,255,0,0,255,1,0,1,1,2,254,0,1,2,0,1,0,254,255,2,0,255,0,0,254,2,2,2,255,0,0,255,255,255,2,0,254,0,254,0,1,1,0,0,0,255,255,255,0,255,0,0,1,254,2,0,0,0,0,255,2,0,1,0,1,0,0,1,255,0,0,1,255,0,1,255,0,1,254,0,1,1,255,1,255,2,255,0,0,255,1,2,254,0,1,0,255,255,0,0,0,2,255,255,1,0,0,255,255,0,1,255,1,2,0,1,0,1,0,1,255,255,254,0,255,254,255,0,1,1,0,0,0,2,255,1,255,0,0,1,255,1,1,0,0,0,0,1,0,254,0,1,254,1,1,2,2,254,2,1,255,2,0,255,0,1,254,255,255,0,255,0,1,254,0,0,255,1,2,255,0,0,255,0,255,0,255,0,1,2,255,0,255,0,0,0,255,1,2,255,1,255,254,2,255,255,0,255,255,0,0,0,0,1,255,2,255,255,1,1,255,2,255,1,255,255,255,254,255,0,254,0,255,1,0,1,1,1,2,0,255,255,1,255,0,255,0,255,0,254,255,255,1,1,255,255,255,254,255,0,0,0,1,255,2,0,0,0,0,2,2,1,1,1,0,1,254,0,0,1,1,0,0,0,1,254,1,0,254,2,255,0,0,0,1,0,0,254,255,2,0,255,0,0,0,0,1,254,255,0,0,0,0,1,1,254,255,255,1,255,2,255,0,255,2,1,0,255,1,1,255,0,1,0,1,2,255,255,0,1,1,0,1,1,254,1,0,0,0,1,255,0,0,255,0,255,254,1,1,254,255,1,254,255,0,1,2,0,255,0,0,255,0,1,254,255,2,0,0,2,1,0,255,0,1,0,254,0,0,0,254,1,2,255,2,1,0,1,255,0,0,0,254,0,0,1,1,255,2,0,1,1,255,0,255,0,1,255,0,0,2,0,255,1,255,2,255,0,1,1,0,0,0,0,2},
  {2,0,1,255,1,255,2,0,255,2,0,255,1,0,2,254,0,2,1,1,2,254,0,0,1,2,255,1,0,2,1,255,1,0,0,0,255,0,1,0,2,255,1,1,1,0,1,255,255,1,1,0,0,255,254,0,255,0,0,0,1,255,254,0,0,0,0,254,0,1,255,0,0,0,254,1,0,0,2,255,1,0,254,0,255,254,0,255,255,255,2,0,255,0,0,0,255,254,255,0,0,0,1,255,255,1,0,0,1,255,1,0,254,0,255,1,1,1,1,0,0,255,1,0,2,1,1,1,255,1,0,1,1,255,1,254,0,0,1,255,1,0,255,0,0,1,255,255,0,1,254,1,255,1,255,254,254,0,254,1,0,255,0,255,1,1,1,0,2,0,255,0,255,0,0,255,255,255,255,0,2,255,2,1,255,255,255,254,1,0,255,0,0,1,1,2,0,0,2,0,0,0,1,0,0,2,255,1,0,255,0,0,254,0,1,255,1,255,0,255,1,255,0,0,0,1,0,0,255,0,255,254,255,255,255,1,0,255,0,0,0,255,1,1,0,1,255,255,255,0,1,0,255,0,255,0,255,0,0,1,255,1,254,255,0,255,2,2,254,0,2,255,0,255,1,1,2,254,0,1,2,0,255,255,1,0,0,2,1,0,1,2,0,255,254,255,0,0,1,0,2,0,255,1,255,0,2,0,255,1,255,1,0,0,2,1,0,1,255,255,0,255,0,255,1,0,1,0,2,1,1,255,0,254,1,1,255,0,1,255,255,0,255,0,0,1,1,255,2,254,0,0,254,0,255,0,0,1,255,1,0,1,0,1,0,255,2,0,255,1,0,0,255,1,255,255,0,1,1,1,0,255,255,1,0,254,254,1,2,255,255,0,1,2,1,1,0,255,1,2,1,0,0,0,0,255,1,0,2,1,1,1,0,1,255,255,1,1,0,1,0,0,255,1,2,2,255,1,2,0,0,1,0,0,0,254,1,1,2,1,2,255,255,0,255,255,0,0,0,255,0,0,0,0,1,255,255,1,255,0,0,0,0,1,255,254,0,0,0,255,255,0,0,255,1,0,255,1,0,255,255,0,1,1,255,0,255,1,254,1,0,1,255,254,0,0,254,0,1,2,1,255,254,0,1,0,2,254,0,0,255,255,1,0,1,255,0,0,2,1,254,255,0,1,254,1,254,255,255,0,0,254,254,0,255,1,0,255,254,1,1,0,255,1,0,0,255,2,1,0,2,1,255,1,254,0,0,255,255,2,255,0,0,1,0,0,2,255,254,0,1,255,254,1,0,255,255,0,0,0,0,1,0,2,0,1,1,255,2,0,2,2,0,0,0,0,0,1,254,255,1,1,0,2,255,1,255,1,1,1,0,0,1,255,1,0,0,2,1,1,254,255,254,0,254,0,255,255,0,255,255,0,254,255,0,1,255,1,2,1,255,255,255,254,0,0,0,255,1,255,254,2,0},
  {2,1,1,1,0,0,0,1,255,0,255,1,1,0,1,2,1,255,0,1,1,2,2,1,254,1,1,0,255,255,0,255,255,0,0,0,2,0,0,1,0,1,0,254,255,254,255,1,255,0,255,1,2,254,1,0,2,0,1,0,1,1,255,255,254,2,2,2,0,1,0,254,2,255,255,2,255,0,255,255,0,1,255,2,0,255,0,0,255,0,255,1,2,254,0,255,0,255,1,0,0,2,0,1,254,1,255,0,0,255,0,0,255,0,0,0,255,255,0,0,255,254,0,254,1,255,1,0,0,1,255,255,255,1,255,1,0,1,254,255,254,1,254,0,255,1,0,0,0,1,254,0,255,254,0,0,254,1,255,0,255,255,254,1,1,1,1,255,255,1,255,0,2,1,255,254,255,255,1,2,0,0,254,0,255,1,255,255,1,1,255,0,0,255,1,0,255,255,1,1,1,254,0,1,0,0,255,1,2,255,0,0,254,255,255,1,255,2,1,0,0,2,255,0,255,0,0,1,0,0,1,254,1,1,1,2,0,0,254,1,0,2,1,0,0,255,2,0,1,0,1,255,254,0,1,0,1,0,2,0,1,1,0,1,1,1,0,255,1,0,0,2,0,1,0,0,1,255,1,255,0,255,0,0,0,255,1,254,255,1,255,1,254,0,255,1,0,0,0,0,255,0,0,255,0,255,255,0,0,254,1,0,0,0,1,255,0,255,1,255,0,1,2,254,1,255,0,255,255,0,1,1,255,1,0,0,1,2,0,2,255,1,0,254,0,0,0,254,255,255,2,254,1,0,255,0,255,255,0,0,0,254,1,1,1,1,1,0,0,255,1,255,0,254,0,255,2,1,0,1,255,0,2,0,0,1,1,1,0,255,1,0,1,255,255,255,1,0,255,0,1,255,1,0,255,255,0,1,2,2,2,0,2,0,1,0,255,255,0,0,254,2,1,0,1,255,1,0,1,254,255,1,1,255,254,0,0,255,2,255,1,255,255,2,1,2,1,1,254,0,254,255,255,2,0,2,0,1,254,254,0,0,1,0,2,0,255,1,0,0,2,1,2,254,255,1,255,0,0,0,255,2,1,254,1,1,2,255,2,0,255,255,255,254,1,2,1,255,255,0,0,0,255,255,0,0,0,1,0,0,255,254,0,1,2,0,2,0,255,255,0,255,254,254,0,0,2,1,254,255,2,0,0,0,2,255,1,0,255,1,2,255,0,1,255,2,255,1,0,0,0,0,0,255,255,255,1,2,0,254,0,0,0,255,254,255,0,255,0,1,1,0,1,255,1,1,0,0,1,255,255,0,1,255,255,0,1,1,0,0,1,255,255,0,1,254,0,255,1,1,1,255,1,0,255,0,1,254,2,255,255,255,0,254,0,255,255,1,255,1,1,255,0,255,0,1,1,1,1,1,0,2,2,255,255,255,1,254,0,0,254,0,1,255,1,0,255,255,1,0,2,255,1},
} ;

static const int16_t precomputed_encode_653xfreeze3_x[precomputed_encode_653xfreeze3_NUM][crypto_encode_ITEMS] = {
  {-1518,6891,18677,4155,-3662,-20499,12176,-2677,-17218,-28578,6723,-5339,-4936,-15954,-29557,-775,21373,29955,-8857,12650,-8823,25158,26305,-6449,9699,24356,-14719,-631,-19947,-7262,-9785,8935,23295,29245,16004,24428,-2647,-12961,9501,32311,-2049,-3042,18370,22576,-31750,22672,-15552,19345,26755,-2228,14913,-4871,21591,-16867,-14512,-18874,-16541,23910,30588,-8998,9365,-32510,-21869,-25491,-28299,-10255,13678,22602,3394,19785,-1511,-21519,27578,31853,736,-5629,30936,-9052,20443,2394,27220,31404,29580,-13690,1399,-6541,22663,-10924,13370,-8379,-6739,6587,19251,-30134,-8540,-20007,-11945,23142,25028,-30664,-30916,7976,-2164,2919,-8920,-29244,31224,1751,-16620,14053,5005,-18078,23928,-27189,-23522,-31170,-7458,-31417,30140,-10029,-28680,17414,7563,-21905,-348,17161,-28641,-24305,6689,-10518,25379,8642,15040,14054,4782,13292,1598,-15527,831,17469,-28138,-24716,1308,-6308,4962,24866,-12777,-16022,16070,-14639,24747,-31821,-20087,-20345,12799,10812,2935,-24234,24005,-25684,5054,2147,-11567,-9605,32351,26877,18329,12893,26631,-16687,2124,-13,-28656,-1494,-21607,24663,-29011,-30363,-6765,18326,25050,-18672,-3544,-4656,5395,31288,-10154,15766,13118,-32291,-4207,23904,-22848,8283,-15217,-1482,-13596,-3013,-26817,14772,796,-9348,5489,-10245,-6848,32578,9693,419,13779,31961,2486,8736,-18872,-31960,-12163,-15936,-16039,-16416,20930,-13364,19634,-32501,-18532,23059,-10240,-20945,-18057,-29177,-57,-5799,18210,29168,-24256,24019,25908,-19128,-18980,23594,-16204,-26382,21782,-30743,8397,26949,-4586,18163,-3964,6613,14133,6768,-31227,-29259,17117,16686,1755,1924,7201,-31285,-6567,5026,-19376,32626,-29780,8340,3526,-15966,19675,-76,-8820,27920,-30607,-1241,-12356,1553,19976,1043,17256,-8580,15784,-16419,31138,13657,25370,-28748,-28115,-31837,-1849,19436,-7111,2636,2731,21148,-26786,24688,31602,25665,-29772,21065,-8131,-43,11769,-8721,-21249,-24867,30864,-18094,-4452,23475,-29822,23090,7814,23099,-28008,-5701,24879,-31042,-558,31992,-10513,23675,-26044,-10985,8015,27448,20612,-31319,11634,-14533,26639,-13937,-25712,-31916,17286,16925,3618,-7055,-25056,14469,24302,25202,17550,10762,26585,28458,-26638,6794,-2029,-29441,-8673,6986,-31140,-14944,-26378,13339,-3622,-3687,29134,-7142,9565,24378,-15757,-29586,14075,7004,9830,19093,-8982,-20203,31994,-26569,-1770,18149,-7971,27533,20242,16115,564,3524,11773,6535,3075,825,5750,-18975,14067,29535,-26941,13951,3510,21499,-10706,-31593,1097,-19510,-17423,27334,24129,-5369,32223,23647,-29509,-9078,10412,10836,-31200,15438,14654,10041,-27351,5722,-17244,-4127,-14900,22162,8756,21957,-25205,-6548,-29295,794,-2894,24820,21373,7519,13584,22431,-30964,17547,-26396,-2910,-8563,22555,12393,26011,-25342,-29154,24356,18991,-16392,19916,18745,17004,-5015,-20441,29160,2098,2619,31515,23388,-9800,21458,30165,2568,-17726,-21442,-15580,6679,-13096,-18777,18581,-2193,7400,-17087,-27869,-14403,14999,-8244,-17174,16222,-10325,-29665,730,3998,23511,-9617,-16367,5396,13542,-26671,-21796,27658,32391,-11576,25733,13583,-13401,1850,-22108,-24475,19433,9041,-30439,15646,-21507,29909,-8729,-22882,-32479,14909,-4956,9748,-26240,5302,24914,28675,-27602,-12558,-13633,21677,-9637,31253,23344,19044,-28902,31627,5192,-6409,27214,-7178,-20987,22471,-22663,-23434,-5629,-27178,15828,-9681,-258,-29491,26476,-20091,10368,3158,3980,2165,21656,14043,13863,14348,27003,26951,13781,14217,-5014,-19697,-16824,-7715,4549,30017,21443,-21457,16855,-28886,-26987,22087,-25416,-2416,15028,23499,13824,-19220,15391,-29558,2971,19925,-9292,-9717,-23897,21799,-6212,21225,527,-30598,19851,20928,-1436,-13074,-4829,-404,31498,-940,-23387,13957,27753,30039,-23393,-1168,-1451,21173,-6927,-29418,2046,12117,16826,-17235,6678,16162,19472,21095,-29569,23177,11693,25522,169,-7553,-30085,-3347,-5950,-15633,15183,1344,-17859,16358,8452,-18282,-23225,10141,-28890,3458,-4146,-30039,16934,18543,32732,-30783,-8719,31683,-25982,-17835,18417,21453,-26861,30107,29638,-8733,-31190,4495,5654,26947,-18326,-4696,-15093,10325,18351,16169,-8616,-2099,-11519,-4812,17176,18890,-26960,7850},
  {17283,28633,5956,-23586,-22445,-7462,9448,20019,-1091,-28628,-13758,23387,24884,28463,-22111,13153,20701,-3008,31772,-15236,4465,-1126,8044,30996,15503,12665,29052,-13624,-13665,-26285,-2119,32333,31089,27921,-19537,-5526,-8937,-3736,-25611,28236,30138,3337,26503,14659,-5209,25302,4421,20831,-26702,-12876,-4871,-23994,-29689,-8761,-28531,-32501,8093,-27880,11197,-26027,24528,-27884,-27790,7106,21129,-2005,-8016,-15831,30710,12080,-2069,11083,30483,-3027,4657,-32227,5765,-29228,-11167,29,-5556,7684,-25486,17655,-3782,21341,-9358,4818,449,2033,18894,25051,1742,-22638,-11279,11168,-14157,-10982,3424,-13387,-11995,-23446,14083,6386,21284,17194,-21376,-6089,11742,10079,-28197,-2966,18380,23253,11135,10987,20785,-1888,20485,13693,-6530,-12260,12960,-31250,-25083,-21318,-15288,-23420,22378,-15299,8779,3674,25620,-27326,-14204,-26098,-18172,-9948,239,-22490,9651,18665,-753,-5409,23219,6238,14031,-5366,-20788,3830,28987,9195,-5492,-23584,25556,30915,-2364,5694,-25110,-20359,-22082,23171,-30739,3892,-21787,-12668,-27833,-12741,2856,-3118,5466,8063,31545,-26813,-31545,30566,-26788,-4894,27428,-1262,4089,-16848,-4573,7648,-13195,-21374,-24500,-14540,-11350,-7416,4499,-19811,-3523,-18906,28389,23744,17829,-28353,15725,-15835,2264,17937,-3547,-22692,9470,-8808,-31946,12895,-20141,-5751,14415,-5949,-25287,-30713,-15817,-19593,11337,18806,15236,-9331,-4836,-26004,-12712,-10178,26298,-23669,-17210,-25066,21361,22317,-22097,-25570,-15627,11308,-18069,24115,19919,-22039,15567,23924,-11976,-12039,20446,-28702,-16444,-25675,-12022,-24438,29316,12743,18278,28706,-18670,17217,23563,3282,32392,3564,-7883,-28154,-29079,7548,-3159,22424,-9607,24824,5226,32048,-5910,-24675,8572,23698,-16834,-5901,-2598,19569,12906,-13639,-22729,4581,10480,-16563,-23156,-12552,28896,-27650,24605,30468,7962,7228,-9598,-18726,3703,14174,11439,919,21922,-15348,10231,-5141,-7363,14536,9200,-21832,-7153,15462,11196,-8740,-15638,-22933,17110,23196,-28514,23970,-15088,23684,25680,-5751,-11316,-30250,-1606,20276,-21395,-20982,20052,-8392,5234,-31527,-25895,15572,-20687,-19483,23709,-32507,12408,-2291,3702,-9455,20768,-7426,17239,-24810,6407,29380,9560,-8418,-24056,15877,31089,-16566,-31224,-28135,20054,-19865,12707,-7161,-20901,-30206,-7981,2743,9013,-26076,-15087,29943,-25554,-8420,-1716,20461,13563,-13349,26668,-7022,3889,-18292,-31471,29605,-18118,-4199,27392,-30154,22071,22373,-21642,-8177,21736,-6328,19139,-25980,23009,17373,-18236,23302,21915,-5454,-1840,-248,-21679,1181,16287,-18390,-232,27891,24905,18825,30689,2115,-15761,-19117,-682,-20115,12932,9753,9357,31758,20114,-16352,-31405,25361,-19406,-5047,30412,-24103,24251,-8434,27558,-12721,-7474,28593,25005,-24438,-855,-10127,-6583,-25762,17114,14675,-15527,-14609,12509,-27430,19988,-10520,1547,13658,-16108,24427,4922,-1431,21139,-22332,9707,11104,-15645,-1745,-4550,4837,-31246,-15699,-1477,-8221,-8276,15686,-8334,3506,1332,12188,-22773,30466,12587,218,-21704,-13412,-9247,22964,-12442,25213,-3481,-26565,-5910,11370,-22520,12611,-31408,-1380,26559,-29538,-16467,-26281,-22750,16039,670,-15572,-19119,-98,22018,8706,24624,-10763,4705,22353,-13854,8346,-24215,27640,-2630,-5478,20095,-21475,9335,32730,-4530,-4944,1321,18348,3423,23926,13958,-25849,24015,13385,-4590,-19305,-29883,-7791,10276,32035,25649,4557,-15837,12273,-5409,-10121,-13304,31393,4667,31049,5224,13358,-23923,-2338,-2634,11177,-19123,-21707,16488,-4015,5305,-25202,15098,-29469,-9398,24570,-4019,-26020,-4369,16712,7776,-16928,10456,-28170,-1964,-25697,32410,-10478,15780,-22947,3462,13591,11579,-27834,11826,-2929,1968,23753,30118,-29315,-18089,28186,23078,5332,26926,-6784,21417,-23303,-17311,-9879,-10831,-1875,27324,19721,-23901,4597,24184,-7150,-19789,-4590,-13425,-25639,-11519,27636,1379,-30363,-17693,384,23935,-12612,24141,-29157,31228,-10535,-17458,31805,-23710,-21971,29715,-3410,8042,-25071,11049,31800,22990,351,13947,-11462,-9386,-8002,-22042,-3132,12271,-21326,12563,15051,32069,-3381,-29888,-10564,32313,-28782,-32611,-23016,16091,-30602,22145,-30172,-11086,12102,13684,-3401,-24675,-1260,-13569,1497,-29863},
  {-25105,16959,-6395,11504,-29849,5132,-29992,22998,-12163,-19111,-14286,26852,13249,16752,-25762,23533,-22209,-18400,7972,5650,-17299,30904,-9483,14577,-20483,-16789,-15709,-2786,-4038,-29347,7414,31739,-31664,-10659,-21033,4488,6392,-27564,9184,-5673,-22153,6242,-10457,8488,11284,7980,-10691,12890,812,14665,-7643,22182,8892,19040,19918,16656,-15220,-29481,-3834,-18609,15178,251,19426,-24723,-300,19170,16704,27397,-25080,-18770,25022,-8793,14628,-2874,26044,202,-15171,-28776,-25876,25496,-29570,-26232,28138,32565,32036,26704,18552,-8602,16142,4763,-20251,-24210,17312,-12813,19569,-29604,24713,27640,-5032,10929,24384,27372,-18494,1259,851,-13469,-8409,13011,-27665,-3253,-21809,-14361,18367,22485,17540,-9314,-16271,-13448,14866,13890,19608,1727,-31934,-2961,-23461,-21722,-10388,-437,27866,-13988,20967,9994,3670,2915,-17672,29341,6372,11388,-10664,17759,-7757,12570,22478,29418,27831,-23348,10406,-8266,23391,-5075,27757,-25883,6287,-30116,-10402,22393,26815,13425,25189,-26696,-25296,-7711,13008,15554,1558,-6386,-7979,-12783,-18040,21837,9926,-10923,25655,22710,-15900,8783,2036,28808,9869,-31260,-29527,-7378,-23392,7876,13307,23603,16658,16477,4615,32619,27650,29196,543,7804,-21788,-32077,30690,31887,-18130,3126,-288,-18768,8605,14895,-26238,-29308,13439,-13409,-28746,25715,-27750,-7053,20314,24096,1267,-6877,-830,-11797,-10413,-11161,13117,-14521,-25050,-13263,-14970,-2381,-22152,29772,-9460,19098,-3364,22069,21242,19832,30965,4741,31995,29606,-456,22611,26844,27596,-30038,1771,-22089,-25589,28370,15986,11069,-19974,-9056,-29823,-8758,1158,-9019,10125,26627,309,-14589,-15317,15263,-11108,28252,-3391,-11511,-1837,-29461,-18337,17092,-1284,-17107,29852,21252,18257,10984,-2513,-23875,29332,-702,-24773,-16951,22983,30056,10538,310,27078,14883,-20617,-17210,-16098,-11822,-29080,29967,27917,16669,19565,-177,-22488,-5450,-14964,-23218,-14634,9074,-15620,15338,28014,-29224,18054,19847,12796,-7111,4774,23760,-25584,-22075,-23654,3969,-10118,-15373,8126,-10947,26240,-18249,30200,-31439,23115,-24812,23937,-17908,-7298,-2783,14291,-2472,25168,-25697,-13295,10904,17163,-11435,19331,17405,31533,-7228,13977,22998,6148,6169,2870,-28183,22051,-16512,-2559,17860,-30828,809,-31827,-16608,-14987,31361,-21359,-9591,-16154,31266,-15167,22590,4841,-23278,-11265,-4801,-29165,27375,-17238,11468,15058,-97,32321,24222,-6443,11272,-16424,-1689,-2167,-382,-10109,-29451,31324,20668,9997,-27952,-1435,9764,6165,-21509,-29107,8089,-23717,4380,10037,-14390,-20146,1123,-28173,11076,25260,633,29378,-28934,23169,-24202,5719,-29087,13789,31368,-22523,-16231,12077,-9089,-17981,4209,-10070,-16959,20241,-613,1630,-21400,-28399,-5791,-26843,-23779,4509,19485,-1502,-18357,-22251,-22206,21985,778,3016,-20080,-12515,-20725,26015,-13501,31986,2747,1382,28245,16983,5022,-2146,-30984,150,-24213,17946,-20489,-9700,3959,-9926,-12115,30843,28983,23400,-1710,-14576,15968,23836,-13431,-5232,5871,6905,-12985,15954,25593,-5293,15472,13668,12140,-5555,1458,18665,24191,-15354,4282,-15896,4841,7629,1433,3913,18508,-13370,-22125,271,22688,24421,18858,29085,31825,-13626,-13826,-31216,-13136,11378,25096,-87,-31301,-6948,-16849,21256,22602,-10479,19112,1871,-10742,20595,6337,-10204,-31002,-22356,-19168,3904,20608,13553,-24141,2281,21682,1564,19264,5708,31190,18426,4506,28390,29653,13026,18377,-29654,-16731,29009,31030,-9317,-27275,14178,20873,-20630,28971,-23694,16775,-28045,5488,14439,-16492,12469,31970,6325,23326,21144,3399,15209,-8518,-24145,7127,5706,26694,-4619,-15861,13485,-21151,28763,23701,23325,-19478,21836,18907,-13457,-23409,16820,-1273,-8901,23472,-6009,17370,-22907,5619,-21397,-20001,9664,6844,16019,-18028,-5916,-30523,-26452,2505,-24837,-7536,23952,-9021,-5174,17731,-11512,-16598,-20327,-17520,-26383,25463,10843,-5116,3124,-29789,-18578,-30243,-10926,-3977,-658,-19646,21639,20187,-29617,-27272,13714,24247,-8065,21289,-15168,22189,2775,11126,287,27972,8243,29285,32334,32647,22133,16491,10114,8384,-12968,-28663,-21518,5846,15101,536,25519,2220,-29712,32253,1703,-28328,56,19408,-18247,3720},
  {-27721,-14759,-6089,-3281,10761,7665,-26943,-4529,524,13392,1586,4450,-10973,-20721,4621,-18751,11860,10211,-26448,6922,2011,-20215,-19657,15622,17740,-27344,2365,3273,22700,15668,-21000,-9496,6677,-18540,-20088,-789,-19342,-32004,25410,11878,21294,-13142,29676,21448,1436,31411,18950,-3482,30506,-1419,-5737,-22718,-25492,16969,5371,-2313,-22780,-6291,-28907,-6021,-12173,-15893,28262,-12409,30556,-24439,-20590,-20155,-31236,-3491,24291,23926,-19258,-4729,26321,-30559,18140,26091,8246,-4009,3582,-3680,19934,-28195,21963,24653,29661,7818,14141,-29445,23108,1252,-26755,24211,28263,4340,10458,3464,1117,25794,16023,-30988,18723,3580,22744,-29057,26138,13971,23022,15164,-32094,-21855,10922,6234,16800,22374,18425,18644,-3966,5064,-4600,27976,-28317,26032,-25586,-1639,-10934,-1071,1269,-10547,15116,-7759,28337,-15002,-14908,4375,28152,-14342,24163,-12397,27520,-31004,24637,8412,15446,-10610,5982,17664,31251,4342,25450,-32253,32093,31579,-30468,11181,19342,-21164,-10261,-12435,23756,25277,29137,-18341,1615,13033,-13379,-15691,13955,15559,10979,11694,-31369,4615,12734,24136,23537,1418,6106,-23050,31044,-12741,26632,-3945,8231,-1757,-4516,-700,-16712,-18974,26750,17871,-19176,14582,-28688,7056,-5104,-16072,-20351,-24008,10381,19867,-26424,-1085,32100,18204,-7390,3568,-25252,12113,13713,-23586,30913,21068,8690,10210,26804,-24613,13714,31554,5181,-29131,-14536,-900,10484,-10020,17562,-7799,-10068,-16641,526,28222,5830,-22598,5374,-23704,-11769,-25491,27079,8041,-8952,-19042,-13922,-8790,-31548,-7471,-25903,-13503,-9323,-10425,2908,10958,17428,-11439,-3752,5409,14932,-32754,-28264,10437,-11768,8791,-17040,-6782,-6680,-1049,-26691,12377,-15938,19950,17955,-19090,6141,-16871,23685,-22278,15082,7541,10579,22145,11562,110,-19191,2595,29328,10265,4561,18361,19076,1090,32000,-12011,29179,7896,6740,-23,-31923,25371,18546,-13398,4052,14721,-11859,-10480,-8772,-10804,-6571,-21129,6777,25954,-15053,4428,-12441,-26448,-377,6710,-10344,-15502,8791,31223,-17697,2218,-31690,21817,-1616,14843,1080,4739,29951,-17895,5254,3601,14960,-19748,19836,-12192,7462,-27604,-31131,-22141,3266,-5096,-27396,31957,-3840,-3645,-17961,21997,-3595,-7480,-21373,31705,-19592,5010,29681,-28389,-7918,12083,-2529,-16992,-6630,16870,10417,-22847,-77,8107,-28466,-3690,28749,14753,-19067,31703,-9426,18937,31077,-14980,-24034,-3380,-25584,10351,11300,-30987,-29086,-10572,-30363,-9977,-24953,3550,-18039,18458,5941,-26337,14953,30953,-4486,-2842,14320,3942,-10573,24576,-18461,-13000,-10787,7824,-2371,-9568,20625,-218,-16720,-28408,-25099,1647,-19540,1563,14437,-27033,26903,18722,-28938,624,21727,-29776,-32618,-21231,-7046,-5002,-1616,-19830,-9968,21175,29483,-25460,-26753,-4396,20716,-20649,-18300,6023,-23644,-160,-15989,22793,-7297,-22258,-22745,-25201,-29609,-13958,32410,21594,21370,-9931,7256,-32314,-16953,-17734,-6222,-25937,30679,31324,-21372,-29682,14245,2529,-20956,30471,25274,-14888,15789,-26469,-31711,-3332,-26722,21793,4601,5140,24950,-19827,16806,-6333,1913,-30715,-10436,28354,-31079,3862,-18748,-13150,-22879,30546,3176,-15232,-1063,26932,10948,-27316,10216,-4999,24374,-5070,-26544,7449,-3199,-14299,4749,1893,-9354,8317,-4080,2229,17612,28312,-24726,-1136,-31039,3360,-23929,-32601,15428,-10288,23238,-11701,20341,26047,1521,18255,-24385,-24143,19306,4298,-23380,18135,-2019,25362,-28135,16559,9619,-19665,28367,-10811,-21757,2597,-18354,-10106,5786,-21280,16937,-28874,24735,31866,-10308,4368,2823,-9475,-8671,-9178,5095,-26968,15630,19927,11916,-2736,11151,-13051,25645,31868,14532,3506,20757,12784,-31634,3423,-9482,-9028,-23516,-10694,-2724,-25710,12943,-8764,12278,15150,-8105,27932,4712,-11682,-8171,-29177,7950,18003,-21182,-8572,-10483,3102,-548,22396,-25497,-1336,8728,-20180,-9593,8441,3103,10578,31727,1422,-9089,24106,-16591,17741,10211,26357,-25776,18004,-31764,-15172,7358,-2801,31601,-25058,14527,7064,-32097,25394,21246,16231,14404,-9188,4075,-25127,15435,-17482,-29380,-5089,18284,-11155,-7193,26725,14889,15825,28099,5385,14551,7793,1906,17799,10385,26669,-887,-12297,-27028,-3547,-25016},
} ;

static void test_encode_653xfreeze3_impl(long long impl)
{
  unsigned char *s = test_encode_653xfreeze3_s;
  unsigned char *x = test_encode_653xfreeze3_x;
  unsigned char *s2 = test_encode_653xfreeze3_s2;
  unsigned char *x2 = test_encode_653xfreeze3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_653xfreeze3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_653xfreeze3(impl);
    printf("encode_653xfreeze3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653xfreeze3_implementation(impl),ntruprime_dispatch_encode_653xfreeze3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_653xfreeze3;
    printf("encode_653xfreeze3 selected implementation %s compiler %s\n",ntruprime_encode_653xfreeze3_implementation(),ntruprime_encode_653xfreeze3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_653xfreeze3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_653xfreeze3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_653xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_653xfreeze3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_653xfreeze3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_653xfreeze3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_653xfreeze3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653xfreeze3")) return;
  storage_encode_653xfreeze3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_653xfreeze3_s = aligned(storage_encode_653xfreeze3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_653xfreeze3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_653xfreeze3_x = aligned(storage_encode_653xfreeze3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_653xfreeze3_s2 = callocplus(maxalloc);
  test_encode_653xfreeze3_s2 = aligned(storage_encode_653xfreeze3_s2,crypto_encode_STRBYTES);
  storage_encode_653xfreeze3_x2 = callocplus(maxalloc);
  test_encode_653xfreeze3_x2 = aligned(storage_encode_653xfreeze3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_653xfreeze3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_653xfreeze3();++impl)
      forked(test_encode_653xfreeze3_impl,impl);
    ++test_encode_653xfreeze3_s;
    ++test_encode_653xfreeze3_x;
    ++test_encode_653xfreeze3_s2;
    ++test_encode_653xfreeze3_x2;
  }
  free(storage_encode_653xfreeze3_x2);
  free(storage_encode_653xfreeze3_s2);
  free(storage_encode_653xfreeze3_x);
  free(storage_encode_653xfreeze3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

