% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{builtin_theme}
\alias{builtin_theme}
\title{The built-in CLI theme}
\usage{
builtin_theme(dark = getOption("cli.theme_dark", "auto"))
}
\arguments{
\item{dark}{Whether to use a dark theme. The \code{cli.theme_dark} option
can be used to request a dark theme explicitly. If this is not set,
or set to \code{"auto"}, then cli tries to detect a dark theme, this
works in recent RStudio versions and in iTerm on macOS.}
}
\value{
A named list, a CLI theme.
}
\description{
This theme is always active, and it is at the bottom of the theme
stack. See \link{themes}.
}
\section{Showcase}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_h1("Heading 1")
cli_h2("Heading 2")
cli_h3("Heading 3")

cli_par()
cli_alert_danger("Danger alert")
cli_alert_warning("Warning alert")
cli_alert_info("Info alert")
cli_alert_success("Success alert")
cli_alert("Alert for starting a process or computation",
  class = "alert-start")
cli_end()

cli_text("Packages and versions: \{.pkg cli\} \{.version 1.0.0\}.")
cli_text("Time intervals: \{.timestamp 3.4s\}")

cli_text("\{.emph Emphasis\} and  \{.strong strong emphasis\}")

cli_text("This is a piece of code: \{.code sum(x) / length(x)\}")
cli_text("Function names: \{.fn cli::simple_theme\}")

cli_text("Files: \{.file /usr/bin/env\}")
cli_text("URLs: \{.url https://r-project.org\}")

cli_h2("Longer code chunk")
cli_par(class = "code R")
cli_verbatim(
  '# window functions are useful for grouped mutates',
  'mtcars \%>\%',
  '  group_by(cyl) \%>\%',
  '  mutate(rank = min_rank(desc(mpg)))')
}\if{html}{\out{</div>}}

\if{html}{\figure{builtin-theme.svg}}
}

\seealso{
\link{themes}, \code{\link[=simple_theme]{simple_theme()}}.
}
