% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrow_subset_linter.R
\name{nrow_subset_linter}
\alias{nrow_subset_linter}
\title{Block usage of \code{nrow(subset(x, .))}}
\usage{
nrow_subset_linter()
}
\description{
Using \code{nrow(subset(x, condition))} to count the instances where \code{condition}
applies inefficiently requires doing a full subset of \code{x} just to
count the number of rows in the resulting subset.
There are a number of equivalent expressions that don't require the full
subset, e.g. \code{with(x, sum(condition))} (or, more generically,
\code{with(x, sum(condition, na.rm = TRUE))}).
}
\examples{
# will produce lints
lint(
  text = "nrow(subset(x, is_treatment))",
  linters = nrow_subset_linter()
)

lint(
  text = "nrow(filter(x, is_treatment))",
  linters = nrow_subset_linter()
)

lint(
  text = "x \%>\% filter(x, is_treatment) \%>\% nrow()",
  linters = nrow_subset_linter()
)

# okay
lint(
  text = "with(x, sum(is_treatment, na.rm = TRUE))",
  linters = nrow_subset_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}
}
